/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.block.column.ColumnEncoding;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.common.block.column.ColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.ColumnEncoderFactory;
import shaded.org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class RunLengthColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        ColumnEncoder columnEncoder = ColumnEncoderFactory.get(ColumnEncoding.deserializeFrom(input));
        Column innerColumn = columnEncoder.readColumn(input, dataType, 1);
        return new RunLengthEncodedColumn(innerColumn, positionCount);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        Column innerColumn = ((RunLengthEncodedColumn)column).getValue();
        if (innerColumn instanceof RunLengthEncodedColumn) {
            throw new IOException("Unable to encode a nested RLE column.");
        }
        innerColumn.getEncoding().serializeTo(output);
        ColumnEncoder columnEncoder = ColumnEncoderFactory.get(innerColumn.getEncoding());
        columnEncoder.writeColumn(output, innerColumn);
    }
}

