/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block.column;

import java.util.Arrays;
import java.util.Objects;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.block.column.ColumnEncoding;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.common.block.column.ColumnUtil;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.RamUsageEstimator;
import shaded.org.apache.tsfile.utils.TsPrimitiveType;

public class RunLengthEncodedColumn
implements Column {
    private static final int INSTANCE_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(RunLengthEncodedColumn.class);
    private final Column value;
    private int positionCount;

    public RunLengthEncodedColumn(Column value, int positionCount) {
        Objects.requireNonNull(value, "value is null");
        if (value.getPositionCount() != 1) {
            throw new IllegalArgumentException(String.format("Expected value to contain a single position but has %s positions", value.getPositionCount()));
        }
        this.value = value instanceof RunLengthEncodedColumn ? ((RunLengthEncodedColumn)value).getValue() : value;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
    }

    public Column getValue() {
        return this.value;
    }

    @Override
    public TSDataType getDataType() {
        return this.value.getDataType();
    }

    @Override
    public ColumnEncoding getEncoding() {
        return ColumnEncoding.RLE;
    }

    @Override
    public boolean getBoolean(int position) {
        return this.value.getBoolean(0);
    }

    @Override
    public int getInt(int position) {
        return this.value.getInt(0);
    }

    @Override
    public long getLong(int position) {
        return this.value.getLong(0);
    }

    @Override
    public float getFloat(int position) {
        return this.value.getFloat(0);
    }

    @Override
    public double getDouble(int position) {
        return this.value.getDouble(0);
    }

    @Override
    public Binary getBinary(int position) {
        return this.value.getBinary(0);
    }

    @Override
    public Object getObject(int position) {
        return this.value.getObject(0);
    }

    @Override
    public boolean[] getBooleans() {
        boolean[] res = new boolean[this.positionCount];
        Arrays.fill(res, this.value.getBoolean(0));
        return res;
    }

    @Override
    public int[] getInts() {
        int[] res = new int[this.positionCount];
        Arrays.fill(res, this.value.getInt(0));
        return res;
    }

    @Override
    public long[] getLongs() {
        long[] res = new long[this.positionCount];
        Arrays.fill(res, this.value.getLong(0));
        return res;
    }

    @Override
    public float[] getFloats() {
        float[] res = new float[this.positionCount];
        Arrays.fill(res, this.value.getFloat(0));
        return res;
    }

    @Override
    public double[] getDoubles() {
        double[] res = new double[this.positionCount];
        Arrays.fill(res, this.value.getDouble(0));
        return res;
    }

    @Override
    public Binary[] getBinaries() {
        Object[] res = new Binary[this.positionCount];
        Arrays.fill(res, this.value.getBinary(0));
        return res;
    }

    @Override
    public Object[] getObjects() {
        Object[] res = new Object[this.positionCount];
        Arrays.fill(res, this.value.getObject(0));
        return res;
    }

    @Override
    public TsPrimitiveType getTsPrimitiveType(int position) {
        return this.value.getTsPrimitiveType(0);
    }

    @Override
    public boolean mayHaveNull() {
        return this.value.mayHaveNull();
    }

    @Override
    public boolean isNull(int position) {
        return this.value.isNull(0);
    }

    @Override
    public boolean[] isNull() {
        boolean[] res = new boolean[this.positionCount];
        Arrays.fill(res, this.value.isNull(0));
        return res;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.value.getRetainedSizeInBytes();
    }

    @Override
    public long getSizeInBytes() {
        return this.value.getSizeInBytes();
    }

    @Override
    public Column getRegion(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.positionCount, positionOffset, length);
        return new RunLengthEncodedColumn(this.value, length);
    }

    @Override
    public Column getRegionCopy(int positionOffset, int length) {
        ColumnUtil.checkValidRegion(this.positionCount, positionOffset, length);
        Column valueCopy = this.value.subColumnCopy(0);
        return new RunLengthEncodedColumn(valueCopy, length);
    }

    @Override
    public Column subColumn(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        return new RunLengthEncodedColumn(this.value, this.positionCount - fromIndex);
    }

    @Override
    public Column subColumnCopy(int fromIndex) {
        if (fromIndex > this.positionCount) {
            throw new IllegalArgumentException("fromIndex is not valid");
        }
        Column valueCopy = this.value.subColumnCopy(0);
        return new RunLengthEncodedColumn(valueCopy, this.positionCount - fromIndex);
    }

    @Override
    public Column getPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            ColumnUtil.checkValidPosition(positions[i], this.positionCount);
        }
        return new RunLengthEncodedColumn(this.value, length);
    }

    @Override
    public Column copyPositions(int[] positions, int offset, int length) {
        ColumnUtil.checkArrayRange(positions, offset, length);
        for (int i = offset; i < offset + length; ++i) {
            ColumnUtil.checkValidPosition(positions[i], this.positionCount);
        }
        return new RunLengthEncodedColumn(this.value.subColumnCopy(0), length);
    }

    @Override
    public void reverse() {
    }

    @Override
    public int getInstanceSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public void setPositionCount(int count) {
        this.positionCount = count;
    }

    @Override
    public void setNull(int start, int end) {
        throw new UnsupportedOperationException(String.format("set null of %s is not supported !", RunLengthEncodedColumn.class.getSimpleName()));
    }
}

