/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.block.column;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.block.column.ColumnEncoding;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.common.block.column.ColumnEncoder;
import shaded.org.apache.tsfile.read.common.block.column.ColumnEncoderFactory;

public class TsBlockSerde {
    public TsBlock deserialize(ByteBuffer byteBuffer) {
        int valueColumnCount = byteBuffer.getInt();
        ArrayList<TSDataType> valueColumnDataTypes = new ArrayList<TSDataType>(valueColumnCount);
        for (int i = 0; i < valueColumnCount; ++i) {
            valueColumnDataTypes.add(TSDataType.deserializeFrom(byteBuffer));
        }
        int positionCount = byteBuffer.getInt();
        ArrayList<ColumnEncoding> columnEncodings = new ArrayList<ColumnEncoding>(valueColumnCount + 1);
        for (int i = 0; i < valueColumnCount + 1; ++i) {
            columnEncodings.add(ColumnEncoding.deserializeFrom(byteBuffer));
        }
        Column timeColumn = ColumnEncoderFactory.get((ColumnEncoding)((Object)columnEncodings.get(0))).readColumn(byteBuffer, TSDataType.INT64, positionCount);
        Column[] valueColumns = new Column[valueColumnCount];
        for (int i = 0; i < valueColumnCount; ++i) {
            valueColumns[i] = ColumnEncoderFactory.get((ColumnEncoding)((Object)columnEncodings.get(1 + i))).readColumn(byteBuffer, (TSDataType)((Object)valueColumnDataTypes.get(i)), positionCount);
        }
        return new TsBlock(positionCount, timeColumn, valueColumns);
    }

    public ByteBuffer serialize(TsBlock tsBlock) throws IOException {
        int i;
        if (tsBlock.getSizeInBytes() > Integer.MAX_VALUE) {
            throw new IllegalStateException("TsBlock should not be that large: " + tsBlock.getSizeInBytes());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)tsBlock.getSizeInBytes());
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(tsBlock.getValueColumnCount());
        for (i = 0; i < tsBlock.getValueColumnCount(); ++i) {
            tsBlock.getColumn(i).getDataType().serializeTo(dataOutputStream);
        }
        dataOutputStream.writeInt(tsBlock.getPositionCount());
        tsBlock.getTimeColumn().getEncoding().serializeTo(dataOutputStream);
        for (i = 0; i < tsBlock.getValueColumnCount(); ++i) {
            tsBlock.getColumn(i).getEncoding().serializeTo(dataOutputStream);
        }
        ColumnEncoder columnEncoder = ColumnEncoderFactory.get(tsBlock.getTimeColumn().getEncoding());
        columnEncoder.writeColumn(dataOutputStream, tsBlock.getTimeColumn());
        for (int i2 = 0; i2 < tsBlock.getValueColumnCount(); ++i2) {
            columnEncoder = ColumnEncoderFactory.get(tsBlock.getColumn(i2).getEncoding());
            columnEncoder.writeColumn(dataOutputStream, tsBlock.getColumn(i2));
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }
}

