/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.type;

import java.util.Collections;
import java.util.List;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.block.column.ColumnBuilder;
import shaded.org.apache.tsfile.read.common.block.column.FloatColumnBuilder;
import shaded.org.apache.tsfile.read.common.type.AbstractType;
import shaded.org.apache.tsfile.read.common.type.Type;
import shaded.org.apache.tsfile.read.common.type.TypeEnum;

public class FloatType
extends AbstractType {
    public static final FloatType FLOAT = new FloatType();

    private FloatType() {
    }

    @Override
    public int getInt(Column c, int position) {
        return (int)c.getFloat(position);
    }

    @Override
    public long getLong(Column c, int position) {
        return (long)c.getFloat(position);
    }

    @Override
    public float getFloat(Column c, int position) {
        return c.getFloat(position);
    }

    @Override
    public double getDouble(Column c, int position) {
        return c.getFloat(position);
    }

    @Override
    public void writeInt(ColumnBuilder builder, int value) {
        builder.writeFloat(value);
    }

    @Override
    public void writeLong(ColumnBuilder builder, long value) {
        builder.writeFloat(value);
    }

    @Override
    public void writeFloat(ColumnBuilder builder, float value) {
        builder.writeFloat(value);
    }

    @Override
    public void writeDouble(ColumnBuilder builder, double value) {
        builder.writeFloat((float)value);
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        return new FloatColumnBuilder(null, expectedEntries);
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.FLOAT;
    }

    @Override
    public String getDisplayName() {
        return "FLOAT";
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.emptyList();
    }

    public static FloatType getInstance() {
        return FLOAT;
    }
}

