/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shaded.org.apache.tsfile.block.column.ColumnBuilder;
import shaded.org.apache.tsfile.read.common.type.AbstractType;
import shaded.org.apache.tsfile.read.common.type.Type;
import shaded.org.apache.tsfile.read.common.type.TypeEnum;

public class RowType
extends AbstractType {
    private final List<Field> fields;
    private final List<Type> fieldTypes;
    private final boolean comparable;
    private final boolean orderable;
    private static final String ROW_NAME = "row";

    private RowType(List<Field> originalFields) {
        this.fields = new ArrayList<Field>(originalFields);
        this.fieldTypes = this.fields.stream().map(Field::getType).collect(Collectors.toList());
        this.comparable = this.fields.stream().allMatch(field -> field.getType().isComparable());
        this.orderable = this.fields.stream().allMatch(field -> field.getType().isOrderable());
    }

    public static RowType from(List<Field> fields) {
        return new RowType(fields);
    }

    public static RowType anonymous(List<Type> types) {
        List<Field> fields = types.stream().map(type -> new Field(Optional.empty(), (Type)type)).collect(Collectors.toList());
        return new RowType(fields);
    }

    public static RowType rowType(Field ... field) {
        return RowType.from(Arrays.asList(field));
    }

    public static RowType anonymousRow(Type ... types) {
        return RowType.anonymous(Arrays.asList(types));
    }

    public static RowType createWithTypeSignature(List<Field> fields) {
        return new RowType(fields);
    }

    public static Field field(String name, Type type) {
        return new Field(Optional.of(name), type);
    }

    public static Field field(Type type) {
        return new Field(Optional.empty(), type);
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.ROW;
    }

    @Override
    public String getDisplayName() {
        StringBuilder result = new StringBuilder();
        result.append(ROW_NAME).append('(');
        for (Field field : this.fields) {
            String typeDisplayName = field.getType().getDisplayName();
            if (field.getName().isPresent()) {
                result.append(field.getName().get()).append(' ').append(typeDisplayName);
            } else {
                result.append(typeDisplayName);
            }
            result.append(", ");
        }
        result.setLength(result.length() - 2);
        result.append(')');
        return result.toString();
    }

    @Override
    public List<Type> getTypeParameters() {
        return this.fieldTypes;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public boolean isComparable() {
        return this.comparable;
    }

    @Override
    public boolean isOrderable() {
        return this.orderable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowType rowType = (RowType)o;
        return this.comparable == rowType.comparable && this.orderable == rowType.orderable && Objects.equals(this.fields, rowType.fields) && Objects.equals(this.fieldTypes, rowType.fieldTypes);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.fieldTypes, this.comparable, this.orderable);
    }

    public static class Field {
        private final Type type;
        private final Optional<String> name;

        public Field(Optional<String> name, Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Type getType() {
            return this.type;
        }

        public Optional<String> getName() {
            return this.name;
        }
    }
}

