/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.type;

import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.common.type.BinaryType;
import shaded.org.apache.tsfile.read.common.type.BlobType;
import shaded.org.apache.tsfile.read.common.type.BooleanType;
import shaded.org.apache.tsfile.read.common.type.DateType;
import shaded.org.apache.tsfile.read.common.type.DoubleType;
import shaded.org.apache.tsfile.read.common.type.FloatType;
import shaded.org.apache.tsfile.read.common.type.IntType;
import shaded.org.apache.tsfile.read.common.type.LongType;
import shaded.org.apache.tsfile.read.common.type.StringType;
import shaded.org.apache.tsfile.read.common.type.TimestampType;
import shaded.org.apache.tsfile.read.common.type.Type;
import shaded.org.apache.tsfile.read.common.type.TypeEnum;
import shaded.org.apache.tsfile.read.common.type.UnknownType;

public class TypeFactory {
    private TypeFactory() {
    }

    public static Type getType(TSDataType tsDataType) {
        switch (tsDataType) {
            case DATE: {
                return DateType.getInstance();
            }
            case INT32: {
                return IntType.getInstance();
            }
            case INT64: {
                return LongType.getInstance();
            }
            case TIMESTAMP: {
                return TimestampType.getInstance();
            }
            case FLOAT: {
                return FloatType.getInstance();
            }
            case DOUBLE: {
                return DoubleType.getInstance();
            }
            case BOOLEAN: {
                return BooleanType.getInstance();
            }
            case TEXT: {
                return BinaryType.getInstance();
            }
            case STRING: {
                return StringType.getInstance();
            }
            case BLOB: {
                return BlobType.getInstance();
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid TSDataType for TypeFactory: %s", new Object[]{tsDataType}));
    }

    public static Type getType(TypeEnum typeEnum) {
        switch (typeEnum) {
            case INT32: {
                return IntType.getInstance();
            }
            case INT64: {
                return LongType.getInstance();
            }
            case FLOAT: {
                return FloatType.getInstance();
            }
            case DOUBLE: {
                return DoubleType.getInstance();
            }
            case BOOLEAN: {
                return BooleanType.getInstance();
            }
            case TEXT: {
                return BinaryType.getInstance();
            }
            case UNKNOWN: {
                return UnknownType.getInstance();
            }
            case DATE: {
                return DateType.getInstance();
            }
            case TIMESTAMP: {
                return TimestampType.getInstance();
            }
            case BLOB: {
                return BlobType.getInstance();
            }
            case STRING: {
                return StringType.getInstance();
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid TypeEnum for TypeFactory: %s", new Object[]{typeEnum}));
    }
}

