/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.common.type;

import java.util.Collections;
import java.util.List;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.block.column.ColumnBuilder;
import shaded.org.apache.tsfile.read.common.block.column.BooleanColumnBuilder;
import shaded.org.apache.tsfile.read.common.type.AbstractType;
import shaded.org.apache.tsfile.read.common.type.Type;
import shaded.org.apache.tsfile.read.common.type.TypeEnum;
import shaded.org.apache.tsfile.utils.Preconditions;

public class UnknownType
extends AbstractType {
    public static final UnknownType UNKNOWN = new UnknownType();
    public static final String NAME = "unknown";

    private UnknownType() {
    }

    @Override
    public void writeBoolean(ColumnBuilder columnBuilder, boolean value) {
        Preconditions.checkArgument(!value);
        columnBuilder.appendNull();
    }

    @Override
    public boolean getBoolean(Column column, int position) {
        Preconditions.checkArgument(column.isNull(position));
        return false;
    }

    @Override
    public ColumnBuilder createColumnBuilder(int expectedEntries) {
        return new BooleanColumnBuilder(null, expectedEntries);
    }

    @Override
    public TypeEnum getTypeEnum() {
        return TypeEnum.UNKNOWN;
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.emptyList();
    }

    public static UnknownType getInstance() {
        return UNKNOWN;
    }
}

