/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.controller;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.file.IMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.DeviceMetadataIndexEntry;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.MetadataIndexNode;
import shaded.org.apache.tsfile.file.metadata.enums.MetadataIndexNodeType;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.read.expression.ExpressionTree;
import shaded.org.apache.tsfile.utils.Pair;

public class DeviceMetaIterator
implements Iterator<Pair<IDeviceID, MetadataIndexNode>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceMetaIterator.class);
    private final TsFileSequenceReader tsFileSequenceReader;
    private final Queue<MetadataIndexNode> metadataIndexNodes = new ArrayDeque<MetadataIndexNode>();
    private final Queue<Pair<IDeviceID, MetadataIndexNode>> resultCache = new ArrayDeque<Pair<IDeviceID, MetadataIndexNode>>();
    private final ExpressionTree idFilter;

    public DeviceMetaIterator(TsFileSequenceReader tsFileSequenceReader, MetadataIndexNode metadataIndexNode, ExpressionTree idFilter) {
        this.tsFileSequenceReader = tsFileSequenceReader;
        this.metadataIndexNodes.add(metadataIndexNode);
        this.idFilter = idFilter;
    }

    @Override
    public boolean hasNext() {
        if (!this.resultCache.isEmpty()) {
            return true;
        }
        try {
            this.loadResults();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load device meta data", e);
            return false;
        }
        return !this.resultCache.isEmpty();
    }

    private void loadLeafDevice(MetadataIndexNode currentNode) throws IOException {
        List<IMetadataIndexEntry> leafChildren = currentNode.getChildren();
        for (int i = 0; i < leafChildren.size(); ++i) {
            IMetadataIndexEntry child = leafChildren.get(i);
            IDeviceID deviceID = ((DeviceMetadataIndexEntry)child).getDeviceID();
            if (this.idFilter != null && !this.idFilter.satisfy(deviceID)) continue;
            long startOffset = child.getOffset();
            long endOffset = i < leafChildren.size() - 1 ? leafChildren.get(i + 1).getOffset() : currentNode.getEndOffset();
            MetadataIndexNode childNode = this.tsFileSequenceReader.readMetadataIndexNode(startOffset, endOffset, false);
            this.resultCache.add(new Pair<IDeviceID, MetadataIndexNode>(deviceID, childNode));
        }
    }

    private void loadInternalNode(MetadataIndexNode currentNode) throws IOException {
        List<IMetadataIndexEntry> internalChildren = currentNode.getChildren();
        for (int i = 0; i < internalChildren.size(); ++i) {
            IMetadataIndexEntry child = internalChildren.get(i);
            long startOffset = child.getOffset();
            long endOffset = i < internalChildren.size() - 1 ? internalChildren.get(i + 1).getOffset() : currentNode.getEndOffset();
            MetadataIndexNode childNode = this.tsFileSequenceReader.readMetadataIndexNode(startOffset, endOffset, true);
            this.metadataIndexNodes.add(childNode);
        }
    }

    private void loadResults() throws IOException {
        block4: while (!this.metadataIndexNodes.isEmpty()) {
            MetadataIndexNode currentNode = this.metadataIndexNodes.poll();
            MetadataIndexNodeType nodeType = currentNode.getNodeType();
            switch (nodeType) {
                case LEAF_DEVICE: {
                    this.loadLeafDevice(currentNode);
                    if (!this.resultCache.isEmpty()) {
                        return;
                    }
                }
                case INTERNAL_DEVICE: {
                    this.loadInternalNode(currentNode);
                    continue block4;
                }
            }
            throw new IOException("A non-device node detected: " + currentNode);
        }
    }

    @Override
    public Pair<IDeviceID, MetadataIndexNode> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.resultCache.poll();
    }
}

