/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import shaded.org.apache.tsfile.common.cache.LRUCache;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.AbstractAlignedTimeSeriesMetadata;
import shaded.org.apache.tsfile.file.metadata.ChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import shaded.org.apache.tsfile.file.metadata.MetadataIndexNode;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.file.metadata.TimeseriesMetadata;
import shaded.org.apache.tsfile.file.metadata.TsFileMetadata;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.controller.DeviceMetaIterator;
import shaded.org.apache.tsfile.read.controller.IMetadataQuerier;
import shaded.org.apache.tsfile.read.expression.ExpressionTree;
import shaded.org.apache.tsfile.utils.Pair;

public class MetadataQuerierByFileImpl
implements IMetadataQuerier {
    private static final int CACHED_ENTRY_NUMBER = 1000;
    private TsFileMetadata fileMetaData;
    private LRUCache<Pair<IDeviceID, String>, List<IChunkMetadata>> deviceIdChunkMetadataCache;
    private TsFileSequenceReader tsFileReader;
    private Map<String, TableSchema> tableSchemaMap;

    public MetadataQuerierByFileImpl(TsFileSequenceReader tsFileReader) throws IOException {
        this.tsFileReader = tsFileReader;
        this.tsFileReader.setEnableCacheTableSchemaMap();
        this.fileMetaData = tsFileReader.readFileMetadata();
        this.tableSchemaMap = tsFileReader.getTableSchemaMap();
        this.deviceIdChunkMetadataCache = new LRUCache<Pair<IDeviceID, String>, List<IChunkMetadata>>(1000){

            @Override
            protected List<IChunkMetadata> loadObjectByKey(Pair<IDeviceID, String> key) throws IOException {
                return MetadataQuerierByFileImpl.this.loadChunkMetadata(key);
            }
        };
    }

    @Override
    public List<IChunkMetadata> getChunkMetaDataList(Path timeseriesPath) throws IOException {
        return new ArrayList<IChunkMetadata>((Collection)this.deviceIdChunkMetadataCache.get(new Pair<IDeviceID, String>(timeseriesPath.getIDeviceID(), timeseriesPath.getMeasurement())));
    }

    @Override
    public List<List<IChunkMetadata>> getChunkMetadataLists(IDeviceID deviceID, Set<String> measurementNames, MetadataIndexNode measurementNode) throws IOException {
        ArrayList<List<IChunkMetadata>> results = new ArrayList<List<IChunkMetadata>>(measurementNames.size());
        Iterator<String> iterator = measurementNames.iterator();
        while (iterator.hasNext()) {
            String measurementName = iterator.next();
            Pair<IDeviceID, String> key = new Pair<IDeviceID, String>(deviceID, measurementName);
            if (!this.deviceIdChunkMetadataCache.containsKey(key)) continue;
            List<IChunkMetadata> metadataList = this.deviceIdChunkMetadataCache.get(key);
            results.add(metadataList);
            iterator.remove();
        }
        List<List<IChunkMetadata>> iChunkMetadataList = this.tsFileReader.getIChunkMetadataList(deviceID, measurementNames, measurementNode);
        for (List<IChunkMetadata> metadataList : iChunkMetadataList) {
            String measurementUid = metadataList.get(0).getMeasurementUid();
            this.deviceIdChunkMetadataCache.put(new Pair<IDeviceID, String>(deviceID, measurementUid), metadataList);
            results.add(metadataList);
        }
        return results;
    }

    @Override
    public Map<Path, List<IChunkMetadata>> getChunkMetaDataMap(List<Path> paths) throws IOException {
        HashMap<Path, List<IChunkMetadata>> chunkMetaDatas = new HashMap<Path, List<IChunkMetadata>>();
        for (Path path : paths) {
            if (!chunkMetaDatas.containsKey(path)) {
                chunkMetaDatas.put(path, new ArrayList());
            }
            ((List)chunkMetaDatas.get(path)).addAll(this.getChunkMetaDataList(path));
        }
        return chunkMetaDatas;
    }

    @Override
    public TsFileMetadata getWholeFileMetadata() {
        return this.fileMetaData;
    }

    @Override
    public Map<String, TableSchema> getTableSchemaMap() {
        return this.tableSchemaMap;
    }

    @Override
    public void loadChunkMetaDatas(List<Path> paths) throws IOException {
        TreeMap deviceMeasurementsMap = new TreeMap();
        for (Path path : paths) {
            if (!deviceMeasurementsMap.containsKey(path.getIDeviceID())) {
                deviceMeasurementsMap.put(path.getIDeviceID(), new HashSet());
            }
            ((Set)deviceMeasurementsMap.get(path.getIDeviceID())).add(path.getMeasurement());
        }
        int count = 0;
        boolean enough = false;
        block1: for (Map.Entry deviceMeasurements : deviceMeasurementsMap.entrySet()) {
            if (enough) break;
            IDeviceID selectedDevice = (IDeviceID)deviceMeasurements.getKey();
            Set selectedMeasurements = (Set)deviceMeasurements.getValue();
            List<IDeviceID> devices = this.tsFileReader.getAllDevices();
            Object[] deviceNames = devices.toArray(new IDeviceID[0]);
            if (Arrays.binarySearch(deviceNames, selectedDevice) < 0) continue;
            List<ITimeSeriesMetadata> timeseriesMetaDataList = this.tsFileReader.readITimeseriesMetadata(selectedDevice, selectedMeasurements, null, false);
            for (ITimeSeriesMetadata timeseriesMetadata : timeseriesMetaDataList) {
                List<IChunkMetadata> chunkMetadataList = this.tsFileReader.readIChunkMetaDataList(timeseriesMetadata);
                String measurementId = timeseriesMetadata instanceof AbstractAlignedTimeSeriesMetadata ? ((AbstractAlignedTimeSeriesMetadata)timeseriesMetadata).getValueTimeseriesMetadataList().get(0).getMeasurementId() : ((TimeseriesMetadata)timeseriesMetadata).getMeasurementId();
                this.deviceIdChunkMetadataCache.put(new Pair<IDeviceID, String>(selectedDevice, measurementId), chunkMetadataList);
                if ((count += chunkMetadataList.size()) != 1000) continue;
                enough = true;
                continue block1;
            }
        }
    }

    @Override
    public TSDataType getDataType(Path path) throws IOException {
        if (this.tsFileReader.getChunkMetadataList(path) == null || this.tsFileReader.getChunkMetadataList(path).isEmpty()) {
            return null;
        }
        return this.tsFileReader.getChunkMetadataList(path).get(0).getDataType();
    }

    private List<IChunkMetadata> loadChunkMetadata(Path path) throws IOException {
        return this.tsFileReader.getIChunkMetadataList(path);
    }

    private List<IChunkMetadata> loadChunkMetadata(Pair<IDeviceID, String> key) throws IOException {
        return this.tsFileReader.getIChunkMetadataList(key.getLeft(), (String)key.right);
    }

    @Override
    public List<TimeRange> convertSpace2TimePartition(List<Path> paths, long spacePartitionStartPos, long spacePartitionEndPos) throws IOException {
        if (spacePartitionStartPos > spacePartitionEndPos) {
            throw new IllegalArgumentException("'spacePartitionStartPos' should not be larger than 'spacePartitionEndPos'.");
        }
        ArrayList<TimeRange> timeRangesInCandidates = new ArrayList<TimeRange>();
        ArrayList<TimeRange> timeRangesBeforeCandidates = new ArrayList<TimeRange>();
        TreeMap<IDeviceID, Set> deviceMeasurementsMap = new TreeMap<IDeviceID, Set>();
        for (Path path : paths) {
            deviceMeasurementsMap.computeIfAbsent(path.getIDeviceID(), key -> new HashSet()).add(path.getMeasurement());
        }
        for (Map.Entry entry : deviceMeasurementsMap.entrySet()) {
            IDeviceID selectedDevice = (IDeviceID)entry.getKey();
            Set selectedMeasurements = (Set)entry.getValue();
            Map<String, List<ChunkMetadata>> seriesMetadatas = this.tsFileReader.readChunkMetadataInDevice(selectedDevice);
            for (Map.Entry<String, List<ChunkMetadata>> seriesMetadata : seriesMetadatas.entrySet()) {
                IChunkMetadata chunkMetadata;
                TsFileSequenceReader.LocateStatus location;
                if (!selectedMeasurements.contains(seriesMetadata.getKey())) continue;
                Iterator<ChunkMetadata> iterator = seriesMetadata.getValue().iterator();
                while (iterator.hasNext() && (location = MetadataQuerierByFileImpl.checkLocateStatus(chunkMetadata = (IChunkMetadata)iterator.next(), spacePartitionStartPos, spacePartitionEndPos)) != TsFileSequenceReader.LocateStatus.AFTER) {
                    if (location == TsFileSequenceReader.LocateStatus.IN) {
                        timeRangesInCandidates.add(new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                        continue;
                    }
                    timeRangesBeforeCandidates.add(new TimeRange(chunkMetadata.getStartTime(), chunkMetadata.getEndTime()));
                }
            }
        }
        ArrayList<TimeRange> timeRangesIn = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesInCandidates));
        if (timeRangesIn.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TimeRange> arrayList = new ArrayList<TimeRange>(TimeRange.sortAndMerge(timeRangesBeforeCandidates));
        ArrayList<TimeRange> resTimeRanges = new ArrayList<TimeRange>();
        for (TimeRange in : timeRangesIn) {
            ArrayList<TimeRange> remains = new ArrayList<TimeRange>(in.getRemains(arrayList));
            resTimeRanges.addAll(remains);
        }
        return resTimeRanges;
    }

    public static TsFileSequenceReader.LocateStatus checkLocateStatus(IChunkMetadata chunkMetaData, long spacePartitionStartPos, long spacePartitionEndPos) {
        long startOffsetOfChunk = chunkMetaData.getOffsetOfChunkHeader();
        if (spacePartitionStartPos <= startOffsetOfChunk && startOffsetOfChunk < spacePartitionEndPos) {
            return TsFileSequenceReader.LocateStatus.IN;
        }
        if (startOffsetOfChunk < spacePartitionStartPos) {
            return TsFileSequenceReader.LocateStatus.BEFORE;
        }
        return TsFileSequenceReader.LocateStatus.AFTER;
    }

    @Override
    public void clear() {
        this.deviceIdChunkMetadataCache.clear();
    }

    @Override
    public Iterator<Pair<IDeviceID, MetadataIndexNode>> deviceIterator(MetadataIndexNode root, ExpressionTree idFilter) {
        return new DeviceMetaIterator(this.tsFileReader, root, idFilter);
    }
}

