/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.filter.basic.ValueFilter;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class LongFilter
extends ValueFilter {
    protected LongFilter(int measurementIndex) {
        super(measurementIndex);
    }

    protected LongFilter(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return this.valueSatisfy(value);
    }

    @Override
    public ReadWriteIOUtils.ClassSerializeId getClassSerializeId() {
        return ReadWriteIOUtils.ClassSerializeId.LONG;
    }

    protected abstract boolean valueSatisfy(long var1);

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = valueColumn.isNull(i) ? false : this.valueSatisfy(valueColumn.getLong(i));
        }
        return satisfyInfo;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
    }
}

