/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.basic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shaded.org.apache.tsfile.file.metadata.IMetadata;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;
import shaded.org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class ValueFilter
extends Filter {
    protected int measurementIndex;

    protected ValueFilter(int measurementIndex) {
        this.measurementIndex = measurementIndex;
    }

    protected ValueFilter(ByteBuffer buffer) {
        this.measurementIndex = ReadWriteIOUtils.readInt(buffer);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        if (value == null) {
            return false;
        }
        return this.valueSatisfy(value);
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        throw new UnSupportedDataTypeException(this.getClass().getName());
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        throw new UnSupportedDataTypeException(this.getClass().getName());
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        throw new UnSupportedDataTypeException(this.getClass().getName());
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        throw new UnSupportedDataTypeException(this.getClass().getName());
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        throw new UnSupportedDataTypeException(this.getClass().getName());
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        throw new UnSupportedDataTypeException(this.getClass().getName());
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.satisfy(time, values[this.measurementIndex]);
    }

    @Override
    public boolean satisfyBooleanRow(long time, boolean[] values) {
        return this.satisfyBoolean(time, values[this.measurementIndex]);
    }

    @Override
    public boolean satisfyIntegerRow(long time, int[] values) {
        return this.satisfyInteger(time, values[this.measurementIndex]);
    }

    @Override
    public boolean satisfyLongRow(long time, long[] values) {
        return this.satisfyLong(time, values[this.measurementIndex]);
    }

    @Override
    public boolean satisfyFloatRow(long time, float[] values) {
        return this.satisfyFloat(time, values[this.measurementIndex]);
    }

    @Override
    public boolean satisfyDoubleRow(long time, double[] values) {
        return this.satisfyDouble(time, values[this.measurementIndex]);
    }

    @Override
    public boolean satisfyBinaryRow(long time, Binary[] values) {
        return this.satisfyBinary(time, values[this.measurementIndex]);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] selection = new boolean[tsBlock.getPositionCount()];
        Arrays.fill(selection, true);
        return this.satisfyTsBlock(selection, tsBlock);
    }

    @Override
    public abstract boolean[] satisfyTsBlock(boolean[] var1, TsBlock var2);

    protected abstract boolean valueSatisfy(Object var1);

    @Override
    public boolean canSkip(IMetadata metadata) {
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        return statistics.map(this::canSkip).orElse(true);
    }

    protected abstract boolean canSkip(Statistics<? extends Serializable> var1);

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        if (metadata.hasNullValue(this.measurementIndex)) {
            return false;
        }
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        return statistics.map(this::allSatisfy).orElse(false);
    }

    protected abstract boolean allSatisfy(Statistics<? extends Serializable> var1);

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return false;
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        throw new UnsupportedOperationException("Value filter does not support getTimeRanges()");
    }

    protected abstract ReadWriteIOUtils.ClassSerializeId getClassSerializeId();

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        ReadWriteIOUtils.write(this.getClassSerializeId().ordinal(), (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.measurementIndex, (OutputStream)outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueFilter that = (ValueFilter)o;
        return this.measurementIndex == that.measurementIndex;
    }

    public int hashCode() {
        return Objects.hash(this.measurementIndex);
    }
}

