/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.operator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shaded.org.apache.tsfile.file.metadata.IMetadata;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.filter.basic.BinaryLogicalFilter;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.filter.basic.OperatorType;
import shaded.org.apache.tsfile.read.filter.operator.Or;
import shaded.org.apache.tsfile.utils.Binary;

public class And
extends BinaryLogicalFilter {
    public And(Filter left, Filter right) {
        super(left, right);
    }

    public And(ByteBuffer buffer) {
        super(Filter.deserialize(buffer), Filter.deserialize(buffer));
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.left.satisfy(time, value) && this.right.satisfy(time, value);
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        return this.left.satisfyBoolean(time, value) && this.right.satisfyBoolean(time, value);
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return this.left.satisfyInteger(time, value) && this.right.satisfyInteger(time, value);
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return this.left.satisfyLong(time, value) && this.right.satisfyLong(time, value);
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return this.left.satisfyFloat(time, value) && this.right.satisfyFloat(time, value);
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        return this.left.satisfyDouble(time, value) && this.right.satisfyDouble(time, value);
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        return this.left.satisfyBinary(time, value) && this.right.satisfyBinary(time, value);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.left.satisfyRow(time, values) && this.right.satisfyRow(time, values);
    }

    @Override
    public boolean satisfyBooleanRow(long time, boolean[] values) {
        return this.left.satisfyBooleanRow(time, values) && this.right.satisfyBooleanRow(time, values);
    }

    @Override
    public boolean satisfyIntegerRow(long time, int[] values) {
        return this.left.satisfyIntegerRow(time, values) && this.right.satisfyIntegerRow(time, values);
    }

    @Override
    public boolean satisfyLongRow(long time, long[] values) {
        return this.left.satisfyLongRow(time, values) && this.right.satisfyLongRow(time, values);
    }

    @Override
    public boolean satisfyFloatRow(long time, float[] values) {
        return this.left.satisfyFloatRow(time, values) && this.right.satisfyFloatRow(time, values);
    }

    @Override
    public boolean satisfyDoubleRow(long time, double[] values) {
        return this.left.satisfyDoubleRow(time, values) && this.right.satisfyDoubleRow(time, values);
    }

    @Override
    public boolean satisfyBinaryRow(long time, Binary[] values) {
        return this.left.satisfyBinaryRow(time, values) && this.right.satisfyBinaryRow(time, values);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] selection = new boolean[tsBlock.getPositionCount()];
        Arrays.fill(selection, true);
        return this.satisfyTsBlock(selection, tsBlock);
    }

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        boolean[] leftResult = this.left.satisfyTsBlock(selection, tsBlock);
        return this.right.satisfyTsBlock(leftResult, tsBlock);
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        return this.left.canSkip(metadata) || this.right.canSkip(metadata);
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        return this.left.allSatisfy(metadata) && this.right.allSatisfy(metadata);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return this.left.satisfyStartEndTime(startTime, endTime) && this.right.satisfyStartEndTime(startTime, endTime);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return this.left.containStartEndTime(startTime, endTime) && this.right.containStartEndTime(startTime, endTime);
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        List<TimeRange> leftTimeRanges = this.left.getTimeRanges();
        List<TimeRange> rightTimeRanges = this.right.getTimeRanges();
        int leftIndex = 0;
        int rightIndex = 0;
        int leftSize = leftTimeRanges.size();
        int rightSize = rightTimeRanges.size();
        while (leftIndex < leftSize && rightIndex < rightSize) {
            TimeRange leftRange = leftTimeRanges.get(leftIndex);
            TimeRange rightRange = rightTimeRanges.get(rightIndex);
            if (leftRange.getMax() < rightRange.getMin()) {
                ++leftIndex;
                continue;
            }
            if (rightRange.getMax() < leftRange.getMin()) {
                ++rightIndex;
                continue;
            }
            TimeRange intersection = new TimeRange(Math.max(leftRange.getMin(), rightRange.getMin()), Math.min(leftRange.getMax(), rightRange.getMax()));
            result.add(intersection);
            if (leftRange.getMax() <= intersection.getMax()) {
                ++leftIndex;
            }
            if (rightRange.getMax() > intersection.getMax()) continue;
            ++rightIndex;
        }
        return result;
    }

    @Override
    public Filter reverse() {
        return new Or(this.left.reverse(), this.right.reverse());
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.AND;
    }

    public String toString() {
        return "(" + this.left + " && " + this.right + ")";
    }
}

