/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.filter.basic.LongFilter;
import shaded.org.apache.tsfile.read.filter.basic.OperatorType;
import shaded.org.apache.tsfile.read.filter.operator.ExtractTimeFilterOperators;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public final class ExtractValueFilterOperators {
    private static final String EXTRACT_OPERATOR_TO_STRING_FORMAT = "extract %s from measurements[%s] %s %s";

    private ExtractValueFilterOperators() {
    }

    public static final class ExtractValueGtEq
    extends ExtractValueCompareFilter {
        public ExtractValueGtEq(int measurementIndex, long constant, ExtractTimeFilterOperators.Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(measurementIndex, new ExtractTimeFilterOperators.ExtractTimeGtEq(constant, field, zoneId, currPrecision));
        }

        public ExtractValueGtEq(ByteBuffer buffer) {
            super(ReadWriteIOUtils.readInt(buffer), (ExtractTimeFilterOperators.ExtractTimeCompareFilter)ExtractTimeFilterOperators.ExtractTimeGtEq.deserialize(buffer));
        }

        @Override
        public Filter reverse() {
            return new ExtractValueLt(this.measurementIndex, this.delegate.getConstant(), this.delegate.getField(), this.delegate.getZoneId(), this.delegate.getCurrPrecision());
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_VALUE_GTEQ;
        }
    }

    public static final class ExtractValueGt
    extends ExtractValueCompareFilter {
        public ExtractValueGt(int measurementIndex, long constant, ExtractTimeFilterOperators.Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(measurementIndex, new ExtractTimeFilterOperators.ExtractTimeGt(constant, field, zoneId, currPrecision));
        }

        public ExtractValueGt(ByteBuffer buffer) {
            super(ReadWriteIOUtils.readInt(buffer), (ExtractTimeFilterOperators.ExtractTimeCompareFilter)ExtractTimeFilterOperators.ExtractTimeGt.deserialize(buffer));
        }

        @Override
        public Filter reverse() {
            return new ExtractValueLtEq(this.measurementIndex, this.delegate.getConstant(), this.delegate.getField(), this.delegate.getZoneId(), this.delegate.getCurrPrecision());
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_VALUE_GT;
        }
    }

    public static final class ExtractValueLtEq
    extends ExtractValueCompareFilter {
        public ExtractValueLtEq(int measurementIndex, long constant, ExtractTimeFilterOperators.Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(measurementIndex, new ExtractTimeFilterOperators.ExtractTimeLtEq(constant, field, zoneId, currPrecision));
        }

        public ExtractValueLtEq(ByteBuffer buffer) {
            super(ReadWriteIOUtils.readInt(buffer), (ExtractTimeFilterOperators.ExtractTimeCompareFilter)ExtractTimeFilterOperators.ExtractTimeLtEq.deserialize(buffer));
        }

        @Override
        public Filter reverse() {
            return new ExtractValueGt(this.measurementIndex, this.delegate.getConstant(), this.delegate.getField(), this.delegate.getZoneId(), this.delegate.getCurrPrecision());
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_VALUE_LTEQ;
        }
    }

    public static final class ExtractValueLt
    extends ExtractValueCompareFilter {
        public ExtractValueLt(int measurementIndex, long constant, ExtractTimeFilterOperators.Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(measurementIndex, new ExtractTimeFilterOperators.ExtractTimeLt(constant, field, zoneId, currPrecision));
        }

        public ExtractValueLt(ByteBuffer buffer) {
            super(ReadWriteIOUtils.readInt(buffer), (ExtractTimeFilterOperators.ExtractTimeCompareFilter)ExtractTimeFilterOperators.ExtractTimeLt.deserialize(buffer));
        }

        @Override
        public Filter reverse() {
            return new ExtractValueGtEq(this.measurementIndex, this.delegate.getConstant(), this.delegate.getField(), this.delegate.getZoneId(), this.delegate.getCurrPrecision());
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_VALUE_LT;
        }
    }

    public static final class ExtractValueNotEq
    extends ExtractValueCompareFilter {
        public ExtractValueNotEq(int measurementIndex, long constant, ExtractTimeFilterOperators.Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(measurementIndex, new ExtractTimeFilterOperators.ExtractTimeNotEq(constant, field, zoneId, currPrecision));
        }

        public ExtractValueNotEq(ByteBuffer buffer) {
            super(ReadWriteIOUtils.readInt(buffer), (ExtractTimeFilterOperators.ExtractTimeCompareFilter)ExtractTimeFilterOperators.ExtractTimeNotEq.deserialize(buffer));
        }

        @Override
        public Filter reverse() {
            return new ExtractValueEq(this.measurementIndex, this.delegate.getConstant(), this.delegate.getField(), this.delegate.getZoneId(), this.delegate.getCurrPrecision());
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_VALUE_NEQ;
        }
    }

    public static final class ExtractValueEq
    extends ExtractValueCompareFilter {
        public ExtractValueEq(int measurementIndex, long constant, ExtractTimeFilterOperators.Field field, ZoneId zoneId, TimeUnit currPrecision) {
            super(measurementIndex, new ExtractTimeFilterOperators.ExtractTimeEq(constant, field, zoneId, currPrecision));
        }

        public ExtractValueEq(ByteBuffer buffer) {
            super(ReadWriteIOUtils.readInt(buffer), (ExtractTimeFilterOperators.ExtractTimeCompareFilter)ExtractTimeFilterOperators.ExtractTimeEq.deserialize(buffer));
        }

        @Override
        public Filter reverse() {
            return new ExtractValueNotEq(this.measurementIndex, this.delegate.getConstant(), this.delegate.getField(), this.delegate.getZoneId(), this.delegate.getCurrPrecision());
        }

        @Override
        public OperatorType getOperatorType() {
            return OperatorType.EXTRACT_VALUE_EQ;
        }
    }

    static abstract class ExtractValueCompareFilter
    extends LongFilter {
        protected final ExtractTimeFilterOperators.ExtractTimeCompareFilter delegate;

        protected ExtractValueCompareFilter(int measurementIndex, ExtractTimeFilterOperators.ExtractTimeCompareFilter delegate) {
            super(measurementIndex);
            this.delegate = delegate;
        }

        @Override
        public void serialize(DataOutputStream outputStream) throws IOException {
            super.serialize(outputStream);
            this.delegate.serialize(outputStream);
        }

        @Override
        public boolean valueSatisfy(Object value) {
            return this.valueSatisfy((Long)value);
        }

        @Override
        public boolean valueSatisfy(long value) {
            return this.delegate.timeSatisfy(value);
        }

        @Override
        public boolean canSkip(Statistics<? extends Serializable> statistics) {
            if (statistics.isEmpty()) {
                return false;
            }
            return !this.delegate.satisfyStartEndTime((Long)statistics.getMinValue(), (Long)statistics.getMaxValue());
        }

        @Override
        public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
            if (statistics.isEmpty()) {
                return false;
            }
            return this.delegate.containStartEndTime((Long)statistics.getMinValue(), (Long)statistics.getMaxValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtractTimeFilterOperators.ExtractTimeCompareFilter thatDelegate = ((ExtractValueCompareFilter)o).delegate;
            return this.delegate.equals(thatDelegate);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.delegate);
        }

        public String toString() {
            return String.format(ExtractValueFilterOperators.EXTRACT_OPERATOR_TO_STRING_FORMAT, new Object[]{this.delegate.getField(), this.measurementIndex, this.getOperatorType().getSymbol(), this.delegate.getConstant()});
        }
    }
}

