/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.filter.basic.OperatorType;
import shaded.org.apache.tsfile.read.filter.operator.GroupByFilter;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;
import shaded.org.apache.tsfile.utils.TimeDuration;

public class GroupByMonthFilter
extends GroupByFilter {
    private final Calendar calendar = Calendar.getInstance();
    private final TimeDuration originalSlidingStep;
    private final TimeDuration originalInterval;
    private TimeZone timeZone;
    private final long originalStartTime;
    private final long originalEndTime;
    private final TimeUnit currPrecision;
    private long[] startTimes;

    public GroupByMonthFilter(long startTime, long endTime, TimeDuration interval, TimeDuration slidingStep, TimeZone timeZone, TimeUnit currPrecision) {
        super(startTime, endTime);
        this.originalStartTime = startTime;
        this.originalEndTime = endTime;
        this.originalInterval = interval;
        this.originalSlidingStep = slidingStep;
        if (!interval.containsMonth()) {
            this.interval = interval.nonMonthDuration;
        }
        if (!slidingStep.containsMonth()) {
            this.slidingStep = slidingStep.nonMonthDuration;
        }
        this.currPrecision = currPrecision;
        this.initMonthGroupByParameters(timeZone);
    }

    public GroupByMonthFilter(ByteBuffer buffer) {
        this(ReadWriteIOUtils.readLong(buffer), ReadWriteIOUtils.readLong(buffer), TimeDuration.deserialize(buffer), TimeDuration.deserialize(buffer), TimeZone.getTimeZone(ReadWriteIOUtils.readString(buffer)), TimeUnit.values()[ReadWriteIOUtils.readInt(buffer)]);
    }

    @Override
    public boolean timeSatisfy(long time) {
        if (time < this.originalStartTime || time >= this.endTime) {
            return false;
        }
        if (time >= this.startTime && time < this.startTime + this.slidingStep) {
            return time - this.startTime < this.interval;
        }
        int count = this.getTimePointPosition(time);
        this.getNthTimeInterval(count);
        return time - this.startTime < this.interval;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.satisfyCurrentInterval(startTime, endTime)) {
            return true;
        }
        int count = this.getTimePointPosition(startTime);
        this.getNthTimeInterval(count);
        if (this.satisfyCurrentInterval(startTime, endTime)) {
            return true;
        }
        this.getNthTimeInterval(count + 1);
        return this.satisfyCurrentInterval(startTime, endTime);
    }

    private boolean satisfyCurrentInterval(long startTime, long endTime) {
        if (endTime < this.startTime || startTime >= this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.isContainedByCurrentInterval(startTime, endTime)) {
            return true;
        }
        int count = this.getTimePointPosition(startTime);
        this.getNthTimeInterval(count);
        return this.isContainedByCurrentInterval(startTime, endTime);
    }

    private boolean isContainedByCurrentInterval(long startTime, long endTime) {
        if (startTime < this.startTime || endTime > this.endTime) {
            return false;
        }
        return startTime - this.startTime < this.interval && endTime - this.startTime < this.interval;
    }

    private void initMonthGroupByParameters(TimeZone timeZone) {
        this.calendar.setTimeZone(timeZone);
        this.timeZone = timeZone;
        this.calendar.setTimeInMillis(this.startTime);
        if (this.originalSlidingStep.containsMonth()) {
            this.startTimes = TimeDuration.getConsecutiveTimesIntervalByMonth(this.startTime, this.originalSlidingStep, (int)Math.ceil((double)(this.originalEndTime - this.originalStartTime) / (double)this.originalSlidingStep.getMinTotalDuration(this.currPrecision)), timeZone, this.currPrecision);
        }
        this.getNthTimeInterval(0);
    }

    private int getTimePointPosition(long time) {
        if (this.originalSlidingStep.containsMonth()) {
            int searchResult = Arrays.binarySearch(this.startTimes, time);
            return searchResult >= 0 ? searchResult : Math.max(0, Math.abs(searchResult) - 2);
        }
        return (int)((time - this.originalStartTime) / this.slidingStep);
    }

    private void getNthTimeInterval(int n) {
        if (this.originalSlidingStep.containsMonth()) {
            if (n < 0 || n > this.startTimes.length - 1) {
                this.interval = -1L;
                return;
            }
            this.startTime = this.startTimes[n];
            this.slidingStep = TimeDuration.calcPositiveIntervalByMonth(this.originalStartTime, this.originalSlidingStep.multiple(n + 1), this.timeZone, this.currPrecision) - this.startTime;
        } else {
            this.startTime = this.originalStartTime + (long)n * this.slidingStep;
        }
        if (this.originalInterval.containsMonth()) {
            this.interval = TimeDuration.calcPositiveIntervalByMonth(this.originalStartTime, this.originalSlidingStep.multiple(n).merge(this.originalInterval), this.timeZone, this.currPrecision) - this.startTime;
        }
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.GROUP_BY_MONTH;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.getOperatorType().ordinal(), (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.originalStartTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.originalEndTime, (OutputStream)outputStream);
        this.originalInterval.serialize(outputStream);
        this.originalSlidingStep.serialize(outputStream);
        ReadWriteIOUtils.write(this.timeZone.getID(), (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.currPrecision.ordinal(), (OutputStream)outputStream);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupByMonthFilter that = (GroupByMonthFilter)o;
        return this.originalStartTime == that.originalStartTime && this.originalEndTime == that.originalEndTime && this.originalSlidingStep.equals(that.originalSlidingStep) && this.originalInterval.equals(that.originalInterval) && this.timeZone.equals(that.timeZone) && this.currPrecision == that.currPrecision && Arrays.equals(this.startTimes, that.startTimes);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.originalSlidingStep, this.originalInterval, this.timeZone, this.originalStartTime, this.originalEndTime, this.currPrecision});
        result = 31 * result + Arrays.hashCode(this.startTimes);
        return result;
    }

    @Override
    public Filter copy() {
        return new GroupByMonthFilter(this.originalStartTime, this.originalEndTime, this.originalInterval, this.originalSlidingStep, this.timeZone, this.currPrecision);
    }
}

