/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.operator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shaded.org.apache.tsfile.file.metadata.IMetadata;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.filter.basic.BinaryLogicalFilter;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.filter.basic.OperatorType;
import shaded.org.apache.tsfile.read.filter.operator.And;
import shaded.org.apache.tsfile.utils.Binary;

public class Or
extends BinaryLogicalFilter {
    public Or(Filter left, Filter right) {
        super(left, right);
    }

    public Or(ByteBuffer buffer) {
        super(Filter.deserialize(buffer), Filter.deserialize(buffer));
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.left.satisfy(time, value) || this.right.satisfy(time, value);
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        return this.left.satisfyBoolean(time, value) || this.right.satisfyBoolean(time, value);
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return this.left.satisfyInteger(time, value) || this.right.satisfyInteger(time, value);
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return this.left.satisfyLong(time, value) || this.right.satisfyLong(time, value);
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return this.left.satisfyFloat(time, value) || this.right.satisfyFloat(time, value);
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        return this.left.satisfyDouble(time, value) || this.right.satisfyDouble(time, value);
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        return this.left.satisfyBinary(time, value) || this.right.satisfyBinary(time, value);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.left.satisfyRow(time, values) || this.right.satisfyRow(time, values);
    }

    @Override
    public boolean satisfyBooleanRow(long time, boolean[] values) {
        return this.left.satisfyBooleanRow(time, values) || this.right.satisfyBooleanRow(time, values);
    }

    @Override
    public boolean satisfyIntegerRow(long time, int[] values) {
        return this.left.satisfyIntegerRow(time, values) || this.right.satisfyIntegerRow(time, values);
    }

    @Override
    public boolean satisfyLongRow(long time, long[] values) {
        return this.left.satisfyLongRow(time, values) || this.right.satisfyLongRow(time, values);
    }

    @Override
    public boolean satisfyFloatRow(long time, float[] values) {
        return this.left.satisfyFloatRow(time, values) || this.right.satisfyFloatRow(time, values);
    }

    @Override
    public boolean satisfyDoubleRow(long time, double[] values) {
        return this.left.satisfyDoubleRow(time, values) || this.right.satisfyDoubleRow(time, values);
    }

    @Override
    public boolean satisfyBinaryRow(long time, Binary[] values) {
        return this.left.satisfyBinaryRow(time, values) || this.right.satisfyBinaryRow(time, values);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] selection = new boolean[tsBlock.getPositionCount()];
        Arrays.fill(selection, true);
        return this.satisfyTsBlock(selection, tsBlock);
    }

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        boolean[] selectionClone = new boolean[selection.length];
        System.arraycopy(selection, 0, selectionClone, 0, selection.length);
        boolean[] leftResult = this.left.satisfyTsBlock(selectionClone, tsBlock);
        for (int i = 0; i < leftResult.length; ++i) {
            if (!leftResult[i]) continue;
            selectionClone[i] = false;
        }
        boolean[] rightResult = this.right.satisfyTsBlock(selectionClone, tsBlock);
        for (int i = 0; i < leftResult.length; ++i) {
            leftResult[i] = leftResult[i] || rightResult[i];
        }
        return leftResult;
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        return this.left.canSkip(metadata) && this.right.canSkip(metadata);
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        return this.left.allSatisfy(metadata) || this.right.allSatisfy(metadata);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        return this.left.satisfyStartEndTime(startTime, endTime) || this.right.satisfyStartEndTime(startTime, endTime);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        return this.left.containStartEndTime(startTime, endTime) || this.right.containStartEndTime(startTime, endTime);
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        List<TimeRange> leftTimeRanges = this.left.getTimeRanges();
        List<TimeRange> rightTimeRanges = this.right.getTimeRanges();
        if (leftTimeRanges.isEmpty()) {
            return rightTimeRanges;
        }
        if (rightTimeRanges.isEmpty()) {
            return leftTimeRanges;
        }
        Index leftIndex = new Index();
        Index rightIndex = new Index();
        TimeRange range = this.chooseNextRange(leftTimeRanges, rightTimeRanges, leftIndex, rightIndex);
        while (leftIndex.getCurrent() < leftTimeRanges.size() || rightIndex.getCurrent() < rightTimeRanges.size()) {
            TimeRange chosenRange = this.chooseNextRange(leftTimeRanges, rightTimeRanges, leftIndex, rightIndex);
            if (chosenRange.getMin() > range.getMax()) {
                result.add(range);
                range = chosenRange;
                continue;
            }
            range.setMax(Math.max(range.getMax(), chosenRange.getMax()));
        }
        result.add(range);
        return result;
    }

    private TimeRange chooseNextRange(List<TimeRange> leftTimeRanges, List<TimeRange> rightTimeRanges, Index leftIndex, Index rightIndex) {
        int leftCurrentIndex = leftIndex.getCurrent();
        int rightCurrentIndex = rightIndex.getCurrent();
        if (leftCurrentIndex < leftTimeRanges.size() && rightCurrentIndex < rightTimeRanges.size()) {
            TimeRange leftRange = leftTimeRanges.get(leftCurrentIndex);
            TimeRange rightRange = rightTimeRanges.get(rightCurrentIndex);
            if (leftRange.getMin() <= rightRange.getMin()) {
                leftIndex.increment();
                return leftRange;
            }
            rightIndex.increment();
            return rightRange;
        }
        if (leftCurrentIndex < leftTimeRanges.size()) {
            leftIndex.increment();
            return leftTimeRanges.get(leftCurrentIndex);
        }
        rightIndex.increment();
        return rightTimeRanges.get(rightCurrentIndex);
    }

    @Override
    public Filter reverse() {
        return new And(this.left.reverse(), this.right.reverse());
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.OR;
    }

    public String toString() {
        return "(" + this.left + " || " + this.right + ")";
    }

    private static class Index {
        private int current = 0;

        public void increment() {
            ++this.current;
        }

        public int getCurrent() {
            return this.current;
        }
    }
}

