/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.filter.operator;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import shaded.org.apache.tsfile.block.column.Column;
import shaded.org.apache.tsfile.exception.NotImplementedException;
import shaded.org.apache.tsfile.file.metadata.IMetadata;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.filter.basic.CompareNullFilter;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.filter.basic.OperatorType;
import shaded.org.apache.tsfile.read.filter.operator.ValueIsNotNullOperator;
import shaded.org.apache.tsfile.utils.Binary;

public class ValueIsNullOperator
extends CompareNullFilter {
    public ValueIsNullOperator(int measurementIndex) {
        super(measurementIndex);
    }

    public ValueIsNullOperator(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return value == null;
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        return false;
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return false;
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return false;
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return false;
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        return false;
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        return value == null;
    }

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        Column valueColumn = tsBlock.getValueColumns()[this.measurementIndex];
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = valueColumn.isNull(i);
        }
        return satisfyInfo;
    }

    @Override
    public Filter reverse() {
        return new ValueIsNotNullOperator(this.measurementIndex);
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.VALUE_IS_NULL;
    }

    @Override
    public boolean valueSatisfy(Object value) {
        return value == null;
    }

    @Override
    public boolean canSkip(Statistics<? extends Serializable> statistics) {
        throw new NotImplementedException();
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        if (!statistics.isPresent()) {
            return false;
        }
        return !metadata.hasNullValue(this.measurementIndex);
    }

    @Override
    public boolean allSatisfy(Statistics<? extends Serializable> statistics) {
        throw new NotImplementedException();
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        Optional<Statistics<? extends Serializable>> statistics = metadata.getMeasurementStatistics(this.measurementIndex);
        if (!statistics.isPresent()) {
            return true;
        }
        return statistics.get().getCount() == 0;
    }
}

