/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.IChunkMetadata;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.read.controller.IChunkLoader;
import shaded.org.apache.tsfile.read.controller.IMetadataQuerier;
import shaded.org.apache.tsfile.read.expression.IExpression;
import shaded.org.apache.tsfile.read.expression.QueryExpression;
import shaded.org.apache.tsfile.read.expression.impl.BinaryExpression;
import shaded.org.apache.tsfile.read.expression.impl.SingleSeriesExpression;
import shaded.org.apache.tsfile.read.query.dataset.DataSetWithTimeGenerator;
import shaded.org.apache.tsfile.read.query.executor.QueryExecutor;
import shaded.org.apache.tsfile.read.query.timegenerator.TsFileTimeGenerator;
import shaded.org.apache.tsfile.read.reader.series.FileSeriesReaderByTimestamp;

public class ExecutorWithTimeGenerator
implements QueryExecutor {
    private IMetadataQuerier metadataQuerier;
    private IChunkLoader chunkLoader;

    public ExecutorWithTimeGenerator(IMetadataQuerier metadataQuerier, IChunkLoader chunkLoader) {
        this.metadataQuerier = metadataQuerier;
        this.chunkLoader = chunkLoader;
    }

    @Override
    public DataSetWithTimeGenerator execute(QueryExpression queryExpression) throws IOException {
        IExpression expression = queryExpression.getExpression();
        List<Path> selectedPathList = queryExpression.getSelectedSeries();
        TsFileTimeGenerator timeGenerator = new TsFileTimeGenerator(expression, this.chunkLoader, this.metadataQuerier);
        List<Boolean> cached = ExecutorWithTimeGenerator.markFilterdPaths(expression, selectedPathList, timeGenerator.hasOrNode());
        ArrayList<FileSeriesReaderByTimestamp> readersOfSelectedSeries = new ArrayList<FileSeriesReaderByTimestamp>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        Iterator<Boolean> cachedIterator = cached.iterator();
        Iterator<Path> selectedPathIterator = selectedPathList.iterator();
        while (cachedIterator.hasNext()) {
            boolean cachedValue = cachedIterator.next();
            Path selectedPath = selectedPathIterator.next();
            List<IChunkMetadata> chunkMetadataList = this.metadataQuerier.getChunkMetaDataList(selectedPath);
            if (!chunkMetadataList.isEmpty()) {
                dataTypes.add(chunkMetadataList.get(0).getDataType());
                if (cachedValue) {
                    readersOfSelectedSeries.add(null);
                    continue;
                }
                FileSeriesReaderByTimestamp seriesReader = new FileSeriesReaderByTimestamp(this.chunkLoader, chunkMetadataList);
                readersOfSelectedSeries.add(seriesReader);
                continue;
            }
            selectedPathIterator.remove();
            cachedIterator.remove();
        }
        return new DataSetWithTimeGenerator(selectedPathList, cached, dataTypes, timeGenerator, readersOfSelectedSeries);
    }

    public static List<Boolean> markFilterdPaths(IExpression expression, List<Path> selectedPaths, boolean hasOrNode) {
        ArrayList<Boolean> cached = new ArrayList<Boolean>();
        if (hasOrNode) {
            for (int i = 0; i < selectedPaths.size(); ++i) {
                cached.add(false);
            }
            return cached;
        }
        HashSet<Path> filteredPaths = new HashSet<Path>();
        ExecutorWithTimeGenerator.getAllFilteredPaths(expression, filteredPaths);
        for (Path selectedPath : selectedPaths) {
            cached.add(filteredPaths.contains(selectedPath));
        }
        return cached;
    }

    private static void getAllFilteredPaths(IExpression expression, HashSet<Path> paths) {
        if (expression instanceof BinaryExpression) {
            ExecutorWithTimeGenerator.getAllFilteredPaths(((BinaryExpression)expression).getLeft(), paths);
            ExecutorWithTimeGenerator.getAllFilteredPaths(((BinaryExpression)expression).getRight(), paths);
        } else if (expression instanceof SingleSeriesExpression) {
            paths.add(((SingleSeriesExpression)expression).getSeriesPath());
        }
    }
}

