/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.query.executor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.org.apache.tsfile.enums.ColumnCategory;
import shaded.org.apache.tsfile.exception.read.NoColumnException;
import shaded.org.apache.tsfile.exception.read.ReadProcessException;
import shaded.org.apache.tsfile.exception.read.UnsupportedOrderingException;
import shaded.org.apache.tsfile.file.metadata.MetadataIndexNode;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.file.metadata.TsFileMetadata;
import shaded.org.apache.tsfile.read.controller.IChunkLoader;
import shaded.org.apache.tsfile.read.controller.IMetadataQuerier;
import shaded.org.apache.tsfile.read.expression.ExpressionTree;
import shaded.org.apache.tsfile.read.query.executor.task.DeviceTaskIterator;
import shaded.org.apache.tsfile.read.reader.block.DeviceOrderedTsBlockReader;
import shaded.org.apache.tsfile.read.reader.block.TsBlockReader;

public class TableQueryExecutor {
    private IMetadataQuerier metadataQuerier;
    private IChunkLoader chunkLoader;
    private TableQueryOrdering tableQueryOrdering;
    private int blockSize = 1024;

    public TableQueryExecutor(IMetadataQuerier metadataQuerier, IChunkLoader chunkLoader, TableQueryOrdering tableQueryOrdering) {
        this.metadataQuerier = metadataQuerier;
        this.chunkLoader = chunkLoader;
        this.tableQueryOrdering = tableQueryOrdering;
    }

    public TsBlockReader query(String tableName, List<String> columns, ExpressionTree timeFilter, ExpressionTree idFilter, ExpressionTree measurementFilter) throws ReadProcessException {
        TsFileMetadata fileMetadata = this.metadataQuerier.getWholeFileMetadata();
        MetadataIndexNode tableRoot = fileMetadata.getTableMetadataIndexNode(tableName);
        TableSchema tableSchema = this.metadataQuerier.getTableSchemaMap().get(tableName);
        if (tableRoot == null || tableSchema == null) {
            return new TsBlockReader.EmptyTsBlockReader();
        }
        ColumnMapping columnMapping = new ColumnMapping();
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            columnMapping.add(column, i, tableSchema);
        }
        columnMapping.add(measurementFilter);
        DeviceTaskIterator deviceTaskIterator = new DeviceTaskIterator(columns, tableRoot, columnMapping, this.metadataQuerier, idFilter, tableSchema);
        switch (this.tableQueryOrdering) {
            case DEVICE: {
                return new DeviceOrderedTsBlockReader(deviceTaskIterator, this.metadataQuerier, this.chunkLoader, timeFilter, measurementFilter, this.blockSize);
            }
        }
        throw new UnsupportedOrderingException(this.tableQueryOrdering.toString());
    }

    public static enum TableQueryOrdering {
        TIME,
        DEVICE;

    }

    public class ColumnMapping {
        private Map<String, List<Integer>> columnPosMap = new HashMap<String, List<Integer>>();
        private Set<String> idColumns = new HashSet<String>();
        private Set<String> measurementColumns = new HashSet<String>();

        public void add(String columnName, int i, TableSchema schema) throws NoColumnException {
            int columnIndex = schema.findColumnIndex(columnName);
            if (columnIndex < 0) {
                throw new NoColumnException(columnName);
            }
            ColumnCategory columnCategory = schema.getColumnTypes().get(columnIndex);
            this.columnPosMap.computeIfAbsent(columnName, k -> new ArrayList()).add(i);
            if (columnCategory.equals((Object)ColumnCategory.TAG)) {
                this.idColumns.add(columnName);
            } else {
                this.measurementColumns.add(columnName);
            }
        }

        public void add(ExpressionTree measurementFilter) {
        }

        public List<Integer> getColumnPos(String columnName) {
            return this.columnPosMap.getOrDefault(columnName, Collections.emptyList());
        }

        public boolean isId(String columnName) {
            return this.idColumns.contains(columnName);
        }

        public boolean isMeasurement(String columnName) {
            return this.measurementColumns.contains(columnName);
        }

        public Set<String> getIdColumns() {
            return this.idColumns;
        }

        public Set<String> getMeasurementColumns() {
            return this.measurementColumns;
        }
    }
}

