/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.exception.filter.QueryFilterOptimizationException;
import shaded.org.apache.tsfile.exception.write.NoMeasurementException;
import shaded.org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IChunkMetadata;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.controller.IChunkLoader;
import shaded.org.apache.tsfile.read.controller.IMetadataQuerier;
import shaded.org.apache.tsfile.read.expression.IExpression;
import shaded.org.apache.tsfile.read.expression.QueryExpression;
import shaded.org.apache.tsfile.read.expression.impl.BinaryExpression;
import shaded.org.apache.tsfile.read.expression.impl.GlobalTimeExpression;
import shaded.org.apache.tsfile.read.expression.util.ExpressionOptimizer;
import shaded.org.apache.tsfile.read.query.dataset.DataSetWithoutTimeGenerator;
import shaded.org.apache.tsfile.read.query.dataset.QueryDataSet;
import shaded.org.apache.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import shaded.org.apache.tsfile.read.query.executor.QueryExecutor;
import shaded.org.apache.tsfile.read.reader.series.AbstractFileSeriesReader;
import shaded.org.apache.tsfile.read.reader.series.EmptyFileSeriesReader;
import shaded.org.apache.tsfile.read.reader.series.FileSeriesReader;
import shaded.org.apache.tsfile.utils.BloomFilter;

public class TsFileExecutor
implements QueryExecutor {
    private IMetadataQuerier metadataQuerier;
    private IChunkLoader chunkLoader;

    public TsFileExecutor(IMetadataQuerier metadataQuerier, IChunkLoader chunkLoader) {
        this.metadataQuerier = metadataQuerier;
        this.chunkLoader = chunkLoader;
    }

    @Override
    public QueryDataSet execute(QueryExpression queryExpression) throws IOException {
        BloomFilter bloomFilter = this.metadataQuerier.getWholeFileMetadata().getBloomFilter();
        ArrayList<Path> filteredSeriesPath = new ArrayList<Path>();
        if (bloomFilter != null) {
            for (Path path : queryExpression.getSelectedSeries()) {
                if (!bloomFilter.contains(path)) continue;
                filteredSeriesPath.add(path);
            }
            queryExpression.setSelectSeries(filteredSeriesPath);
        }
        this.metadataQuerier.loadChunkMetaDatas(queryExpression.getSelectedSeries());
        if (queryExpression.hasQueryFilter()) {
            try {
                IExpression expression = queryExpression.getExpression();
                IExpression regularIExpression = ExpressionOptimizer.getInstance().optimize(expression, queryExpression.getSelectedSeries());
                queryExpression.setExpression(regularIExpression);
                if (regularIExpression instanceof GlobalTimeExpression) {
                    return this.execute(queryExpression.getSelectedSeries(), (GlobalTimeExpression)regularIExpression);
                }
                return new ExecutorWithTimeGenerator(this.metadataQuerier, this.chunkLoader).execute(queryExpression);
            }
            catch (QueryFilterOptimizationException | NoMeasurementException e) {
                throw new IOException(e);
            }
        }
        try {
            return this.execute(queryExpression.getSelectedSeries());
        }
        catch (NoMeasurementException e) {
            throw new IOException(e);
        }
    }

    public QueryDataSet execute(QueryExpression queryExpression, long spacePartitionStartPos, long spacePartitionEndPos) throws IOException {
        ArrayList<TimeRange> resTimeRanges = new ArrayList<TimeRange>(this.metadataQuerier.convertSpace2TimePartition(queryExpression.getSelectedSeries(), spacePartitionStartPos, spacePartitionEndPos));
        if (resTimeRanges.isEmpty()) {
            return new DataSetWithoutTimeGenerator(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        IExpression addTimeExpression = resTimeRanges.get(0).getExpression();
        for (int i = 1; i < resTimeRanges.size(); ++i) {
            addTimeExpression = BinaryExpression.or(addTimeExpression, resTimeRanges.get(i).getExpression());
        }
        if (queryExpression.hasQueryFilter()) {
            BinaryExpression.AndExpression combinedExpression = BinaryExpression.and(queryExpression.getExpression(), addTimeExpression);
            queryExpression.setExpression(combinedExpression);
        } else {
            queryExpression.setExpression(addTimeExpression);
        }
        return this.execute(queryExpression);
    }

    private QueryDataSet execute(List<Path> selectedPathList) throws IOException, NoMeasurementException {
        return this.executeMayAttachTimeFiler(selectedPathList, null);
    }

    private QueryDataSet execute(List<Path> selectedPathList, GlobalTimeExpression timeFilter) throws IOException, NoMeasurementException {
        return this.executeMayAttachTimeFiler(selectedPathList, timeFilter);
    }

    private QueryDataSet executeMayAttachTimeFiler(List<Path> selectedPathList, GlobalTimeExpression timeExpression) throws IOException, NoMeasurementException {
        ArrayList<AbstractFileSeriesReader> readersOfSelectedSeries = new ArrayList<AbstractFileSeriesReader>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : selectedPathList) {
            AbstractFileSeriesReader seriesReader;
            List<IChunkMetadata> chunkMetadataList = this.metadataQuerier.getChunkMetaDataList(path);
            if (chunkMetadataList.isEmpty()) {
                seriesReader = new EmptyFileSeriesReader();
                dataTypes.add(this.metadataQuerier.getDataType(path));
            } else {
                seriesReader = timeExpression == null ? new FileSeriesReader(this.chunkLoader, chunkMetadataList, null) : new FileSeriesReader(this.chunkLoader, chunkMetadataList, timeExpression.getFilter());
                IChunkMetadata iChunkMetadata = chunkMetadataList.get(0);
                TSDataType dataType = iChunkMetadata instanceof AlignedChunkMetadata ? ((AlignedChunkMetadata)iChunkMetadata).getValueChunkMetadataList().get(0).getDataType() : iChunkMetadata.getDataType();
                dataTypes.add(dataType);
            }
            readersOfSelectedSeries.add(seriesReader);
        }
        return new DataSetWithoutTimeGenerator(selectedPathList, dataTypes, readersOfSelectedSeries);
    }
}

