/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.query.timegenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.read.expression.ExpressionType;
import shaded.org.apache.tsfile.read.expression.IBinaryExpression;
import shaded.org.apache.tsfile.read.expression.IExpression;
import shaded.org.apache.tsfile.read.expression.impl.SingleSeriesExpression;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.query.timegenerator.node.AndNode;
import shaded.org.apache.tsfile.read.query.timegenerator.node.LeafNode;
import shaded.org.apache.tsfile.read.query.timegenerator.node.Node;
import shaded.org.apache.tsfile.read.query.timegenerator.node.OrNode;
import shaded.org.apache.tsfile.read.reader.IBatchReader;
import shaded.org.apache.tsfile.write.UnSupportedDataTypeException;

public abstract class TimeGenerator {
    private HashMap<Path, List<LeafNode>> leafNodeCache = new HashMap();
    private HashMap<Path, List<Object>> leafValuesCache;
    protected Node operatorNode;
    private boolean hasOrNode;

    public boolean hasNext() throws IOException {
        return this.operatorNode.hasNext();
    }

    public long next() throws IOException {
        if (!this.hasOrNode) {
            if (this.leafValuesCache == null) {
                this.leafValuesCache = new HashMap();
            }
            this.leafNodeCache.forEach((path, nodes) -> this.leafValuesCache.computeIfAbsent((Path)path, k -> new ArrayList()).add(((LeafNode)nodes.get(0)).currentValue()));
        }
        return this.operatorNode.next();
    }

    public Object[] getValues(Path path) throws IOException {
        if (this.hasOrNode) {
            throw new IOException("getValues() method should not be invoked when there is OR operator in where clause");
        }
        if (this.leafValuesCache.get(path) == null) {
            throw new IOException("getValues() method should not be invoked by non-existent path in where clause");
        }
        return this.leafValuesCache.remove(path).toArray();
    }

    public Object getValue(Path path) throws IOException {
        if (this.hasOrNode) {
            throw new IOException("getValue() method should not be invoked when there is OR operator in where clause");
        }
        if (this.leafValuesCache.get(path) == null) {
            throw new IOException("getValue() method should not be invoked by non-existent path in where clause");
        }
        return this.leafValuesCache.get(path).remove(0);
    }

    public void constructNode(IExpression expression) throws IOException {
        this.operatorNode = this.construct(expression);
    }

    protected Node construct(IExpression expression) throws IOException {
        if (expression.getType() == ExpressionType.SERIES) {
            SingleSeriesExpression singleSeriesExp = (SingleSeriesExpression)expression;
            IBatchReader seriesReader = this.generateNewBatchReader(singleSeriesExp);
            Path path = singleSeriesExp.getSeriesPath();
            LeafNode leafNode = new LeafNode(seriesReader);
            this.leafNodeCache.computeIfAbsent(path, p -> new ArrayList()).add(leafNode);
            return leafNode;
        }
        Node leftChild = this.construct(((IBinaryExpression)expression).getLeft());
        Node rightChild = this.construct(((IBinaryExpression)expression).getRight());
        if (expression.getType() == ExpressionType.OR) {
            this.hasOrNode = true;
            return new OrNode(leftChild, rightChild, this.isAscending());
        }
        if (expression.getType() == ExpressionType.AND) {
            return new AndNode(leftChild, rightChild, this.isAscending());
        }
        throw new UnSupportedDataTypeException("Unsupported ExpressionType when construct OperatorNode: " + (Object)((Object)expression.getType()));
    }

    protected abstract IBatchReader generateNewBatchReader(SingleSeriesExpression var1) throws IOException;

    public boolean hasOrNode() {
        return this.hasOrNode;
    }

    protected abstract boolean isAscending();

    public abstract Filter getTimeFilter();
}

