/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.compress.IUnCompressor;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.header.PageHeader;
import shaded.org.apache.tsfile.file.metadata.ChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.TimeseriesMetadata;
import shaded.org.apache.tsfile.file.metadata.enums.CompressionType;
import shaded.org.apache.tsfile.read.TimeValuePair;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.read.common.BatchData;
import shaded.org.apache.tsfile.read.common.Chunk;
import shaded.org.apache.tsfile.read.reader.chunk.ChunkReader;
import shaded.org.apache.tsfile.read.reader.page.ValuePageReader;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.TsPrimitiveType;

public class TsFileLastReader
implements AutoCloseable,
Iterator<Pair<IDeviceID, List<Pair<String, TimeValuePair>>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileLastReader.class);
    private final TsFileSequenceReader sequenceReader;
    private boolean asyncIO = true;
    private boolean ignoreBlob = false;
    private Iterator<Pair<IDeviceID, List<TimeseriesMetadata>>> timeseriesMetadataIter;
    private Pair<IDeviceID, List<Pair<String, TimeValuePair>>> nextValue;
    private BlockingQueue<Pair<IDeviceID, List<Pair<String, TimeValuePair>>>> lastValueQueue;
    private ForkJoinTask<Void> asyncTask;

    public TsFileLastReader(String filePath) throws IOException {
        this.sequenceReader = new TsFileSequenceReader(filePath);
    }

    public TsFileLastReader(String filePath, boolean asyncIO, boolean ignoreBlob) throws IOException {
        this(filePath);
        this.asyncIO = asyncIO;
        this.ignoreBlob = ignoreBlob;
    }

    @Override
    public boolean hasNext() {
        if (this.timeseriesMetadataIter == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                LOGGER.error("Cannot read timeseries metadata from {}", (Object)this.sequenceReader.getFileName(), (Object)e);
                return false;
            }
        }
        if (this.nextValue != null) {
            return this.nextValue.getLeft() != null;
        }
        if (this.asyncIO) {
            return this.hasNextAsync();
        }
        return this.hasNextSync();
    }

    private boolean hasNextSync() {
        if (!this.timeseriesMetadataIter.hasNext()) {
            this.nextValue = new Pair<Object, Object>(null, null);
        } else {
            Pair<IDeviceID, List<TimeseriesMetadata>> next = this.timeseriesMetadataIter.next();
            try {
                this.nextValue = new Pair<IDeviceID, List<Pair<String, TimeValuePair>>>((IDeviceID)next.left, this.convertToLastPoints((List)next.right));
            }
            catch (IOException e) {
                LOGGER.error("Cannot read timeseries metadata from {}", (Object)this.sequenceReader.getFileName(), (Object)e);
                return false;
            }
        }
        return this.nextValue.left != null;
    }

    private boolean hasNextAsync() {
        try {
            this.nextValue = this.lastValueQueue.take();
            if (this.nextValue.getLeft() == null) {
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        return this.nextValue.left != null;
    }

    @Override
    public Pair<IDeviceID, List<Pair<String, TimeValuePair>>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Pair<IDeviceID, List<Pair<String, TimeValuePair>>> ret = this.nextValue;
        this.nextValue = null;
        return ret;
    }

    private List<Pair<String, TimeValuePair>> convertToLastPoints(List<TimeseriesMetadata> timeseriesMetadataList) throws IOException {
        boolean isAligned = timeseriesMetadataList.get(0).getTsDataType() == TSDataType.VECTOR;
        ArrayList<Pair<String, TimeValuePair>> list = new ArrayList<Pair<String, TimeValuePair>>();
        for (TimeseriesMetadata meta : timeseriesMetadataList) {
            Pair<String, TimeValuePair> stringTimeValuePairPair = this.convertToLastPoint(meta, isAligned);
            list.add(stringTimeValuePairPair);
        }
        return list;
    }

    private TimeValuePair readNonAlignedLastPoint(Chunk chunk) throws IOException {
        ChunkReader chunkReader = new ChunkReader(chunk);
        BatchData batchData = null;
        while (chunkReader.hasNextSatisfiedPage()) {
            batchData = chunkReader.nextPageData();
        }
        if (batchData != null) {
            return batchData.getLastPairBeforeOrEqualTimestamp(Long.MAX_VALUE);
        }
        return null;
    }

    private TimeValuePair readAlignedLastPoint(Chunk chunk, ChunkMetadata chunkMetadata, long endTime) throws IOException {
        ByteBuffer chunkData = chunk.getData();
        PageHeader lastPageHeader = null;
        ByteBuffer lastPageData = null;
        while (chunkData.hasRemaining()) {
            PageHeader pageHeader = chunk.isSinglePageChunk() ? PageHeader.deserializeFrom(chunkData, chunkMetadata.getStatistics()) : PageHeader.deserializeFrom(chunkData, TSDataType.BLOB);
            ByteBuffer pageData = chunkData.slice();
            pageData.limit(pageData.position() + pageHeader.getCompressedSize());
            chunkData.position(chunkData.position() + pageHeader.getCompressedSize());
            if ((pageHeader.getStatistics() != null || pageHeader.getUncompressedSize() == 0) && (pageHeader.getStatistics() == null || pageHeader.getStatistics().getCount() <= 0)) continue;
            lastPageHeader = pageHeader;
            lastPageData = pageData;
        }
        if (lastPageHeader != null) {
            CompressionType compressionType = chunk.getHeader().getCompressionType();
            if (compressionType != CompressionType.UNCOMPRESSED) {
                ByteBuffer uncompressedPage = ByteBuffer.allocate(lastPageHeader.getUncompressedSize());
                IUnCompressor.getUnCompressor(compressionType).uncompress(lastPageData, uncompressedPage);
                lastPageData = uncompressedPage;
                lastPageData.flip();
            }
            ValuePageReader valuePageReader = new ValuePageReader(lastPageHeader, lastPageData, TSDataType.BLOB, Decoder.getDecoderByType(chunk.getHeader().getEncodingType(), TSDataType.BLOB));
            TsPrimitiveType lastValue = null;
            for (int i = 0; i < valuePageReader.getSize(); ++i) {
                lastValue = valuePageReader.nextValue(0L, i);
            }
            return new TimeValuePair(endTime, lastValue);
        }
        return null;
    }

    private Pair<String, TimeValuePair> convertToLastPoint(TimeseriesMetadata seriesMeta, boolean isAligned) throws IOException {
        if (seriesMeta.getTsDataType() != TSDataType.BLOB) {
            return new Pair<String, TimeValuePair>(seriesMeta.getMeasurementId(), new TimeValuePair(seriesMeta.getStatistics().getEndTime(), seriesMeta.getTsDataType() == TSDataType.VECTOR ? TsPrimitiveType.getByType(TSDataType.INT64, seriesMeta.getStatistics().getEndTime()) : TsPrimitiveType.getByType(seriesMeta.getTsDataType(), seriesMeta.getStatistics().getLastValue())));
        }
        return this.readLastPoint(seriesMeta, isAligned);
    }

    private Pair<String, TimeValuePair> readLastPoint(TimeseriesMetadata seriesMeta, boolean isAligned) throws IOException {
        if (seriesMeta.getChunkMetadataList() == null) {
            return new Pair<String, Object>(seriesMeta.getMeasurementId(), null);
        }
        ChunkMetadata lastNonEmptyChunkMetadata = null;
        for (int i = seriesMeta.getChunkMetadataList().size() - 1; i >= 0; --i) {
            ChunkMetadata chunkMetadata = (ChunkMetadata)seriesMeta.getChunkMetadataList().get(i);
            if (chunkMetadata.getStatistics() != null && chunkMetadata.getStatistics().getCount() <= 0) continue;
            lastNonEmptyChunkMetadata = chunkMetadata;
            break;
        }
        if (lastNonEmptyChunkMetadata == null) {
            return new Pair<String, Object>(seriesMeta.getMeasurementId(), null);
        }
        Chunk chunk = this.sequenceReader.readMemChunk(lastNonEmptyChunkMetadata);
        if (!isAligned) {
            return new Pair<String, TimeValuePair>(seriesMeta.getMeasurementId(), this.readNonAlignedLastPoint(chunk));
        }
        return new Pair<String, TimeValuePair>(seriesMeta.getMeasurementId(), this.readAlignedLastPoint(chunk, lastNonEmptyChunkMetadata, seriesMeta.getStatistics().getEndTime()));
    }

    private void init() throws IOException {
        this.timeseriesMetadataIter = this.sequenceReader.iterAllTimeseriesMetadata(false, !this.ignoreBlob);
        if (this.asyncIO) {
            int queueCapacity = 1024;
            this.lastValueQueue = new ArrayBlockingQueue<Pair<IDeviceID, List<Pair<String, TimeValuePair>>>>(queueCapacity);
            this.asyncTask = ForkJoinPool.commonPool().submit(() -> {
                try {
                    while (this.timeseriesMetadataIter.hasNext()) {
                        Pair<IDeviceID, List<TimeseriesMetadata>> deviceSeriesMetadata = this.timeseriesMetadataIter.next();
                        this.lastValueQueue.put(new Pair<IDeviceID, List<Pair<String, TimeValuePair>>>((IDeviceID)deviceSeriesMetadata.left, this.convertToLastPoints((List)deviceSeriesMetadata.right)));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOGGER.error("Error while reading timeseries metadata", e);
                }
                finally {
                    try {
                        this.lastValueQueue.put(new Pair<Object, Object>(null, null));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                return null;
            });
        }
    }

    @Override
    public void close() throws Exception {
        if (this.asyncIO && this.asyncTask != null) {
            this.asyncTask.cancel(true);
        }
        this.sequenceReader.close();
    }
}

