/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.reader.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.header.PageHeader;
import shaded.org.apache.tsfile.read.common.Chunk;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.reader.chunk.AbstractAlignedChunkReader;
import shaded.org.apache.tsfile.read.reader.page.AbstractAlignedPageReader;
import shaded.org.apache.tsfile.read.reader.page.AlignedPageReader;
import shaded.org.apache.tsfile.read.reader.page.LazyLoadPageData;

public class AlignedChunkReader
extends AbstractAlignedChunkReader {
    public AlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, long readStopTime, Filter queryFilter) throws IOException {
        super(timeChunk, valueChunkList, readStopTime, queryFilter);
    }

    public AlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList) throws IOException {
        this(timeChunk, valueChunkList, Long.MIN_VALUE, null);
    }

    public AlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, Filter queryFilter) throws IOException {
        this(timeChunk, valueChunkList, Long.MIN_VALUE, queryFilter);
    }

    public AlignedChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, long readStopTime) throws IOException {
        this(timeChunk, valueChunkList, readStopTime, null);
    }

    @Override
    boolean needSkipForSinglePageChunk(boolean isAllNull, PageHeader timePageHeader) {
        return isAllNull || this.isEarlierThanReadStopTime(timePageHeader);
    }

    @Override
    boolean needSkipForMultiPageChunk(boolean isAllNull, PageHeader timePageHeader) {
        return isAllNull || this.isEarlierThanReadStopTime(timePageHeader) || this.pageCanSkip(timePageHeader);
    }

    @Override
    boolean canSkip(boolean isAllNull, PageHeader timePageHeader) {
        return isAllNull;
    }

    @Override
    AbstractAlignedPageReader constructPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, LazyLoadPageData[] lazyLoadPageDataArray, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter queryFilter, List<List<TimeRange>> valueDeleteIntervalsList) {
        AlignedPageReader alignedPageReader = new AlignedPageReader(timePageHeader, timePageData, timeDecoder, valuePageHeaderList, lazyLoadPageDataArray, valueDataTypeList, valueDecoderList, queryFilter);
        alignedPageReader.setDeleteIntervalList(valueDeleteIntervalsList);
        return alignedPageReader;
    }
}

