/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.reader.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.header.PageHeader;
import shaded.org.apache.tsfile.read.common.Chunk;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.reader.chunk.AbstractAlignedChunkReader;
import shaded.org.apache.tsfile.read.reader.page.AbstractAlignedPageReader;
import shaded.org.apache.tsfile.read.reader.page.LazyLoadPageData;
import shaded.org.apache.tsfile.read.reader.page.TablePageReader;

public class TableChunkReader
extends AbstractAlignedChunkReader {
    public TableChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, long readStopTime, Filter queryFilter) throws IOException {
        super(timeChunk, valueChunkList, readStopTime, queryFilter);
    }

    public TableChunkReader(Chunk timeChunk, List<Chunk> valueChunkList, Filter queryFilter) throws IOException {
        this(timeChunk, valueChunkList, Long.MIN_VALUE, queryFilter);
    }

    @Override
    boolean needSkipForSinglePageChunk(boolean isAllNull, PageHeader timePageHeader) {
        return this.isEarlierThanReadStopTime(timePageHeader);
    }

    @Override
    boolean needSkipForMultiPageChunk(boolean isAllNull, PageHeader timePageHeader) {
        return this.isEarlierThanReadStopTime(timePageHeader) || this.pageCanSkip(timePageHeader);
    }

    @Override
    boolean canSkip(boolean isAllNull, PageHeader timePageHeader) {
        return this.pageDeleted(timePageHeader, this.timeDeleteIntervalList);
    }

    @Override
    AbstractAlignedPageReader constructPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, LazyLoadPageData[] lazyLoadPageDataArray, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter queryFilter, List<List<TimeRange>> valueDeleteIntervalsList) {
        TablePageReader alignedPageReader = new TablePageReader(timePageHeader, timePageData, timeDecoder, valuePageHeaderList, lazyLoadPageDataArray, valueDataTypeList, valueDecoderList, queryFilter);
        alignedPageReader.setDeleteIntervalList(this.timeDeleteIntervalList, valueDeleteIntervalsList);
        return alignedPageReader;
    }
}

