/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.header.PageHeader;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.common.BatchData;
import shaded.org.apache.tsfile.read.common.BatchDataFactory;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.common.block.TsBlockBuilder;
import shaded.org.apache.tsfile.read.common.block.TsBlockUtil;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.reader.IPageReader;
import shaded.org.apache.tsfile.read.reader.page.LazyLoadPageData;
import shaded.org.apache.tsfile.read.reader.page.TimePageReader;
import shaded.org.apache.tsfile.read.reader.page.ValuePageReader;
import shaded.org.apache.tsfile.read.reader.series.PaginationController;
import shaded.org.apache.tsfile.utils.TsPrimitiveType;

public abstract class AbstractAlignedPageReader
implements IPageReader {
    protected final TimePageReader timePageReader;
    protected final List<ValuePageReader> valuePageReaderList;
    protected final int valueCount;
    protected final Filter globalTimeFilter;
    protected Filter pushDownFilter;
    protected PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    protected boolean isModified;
    protected TsBlockBuilder builder;
    protected static final int MASK = 128;

    AbstractAlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, List<ByteBuffer> valuePageDataList, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        this.timePageReader = new TimePageReader(timePageHeader, timePageData, timeDecoder);
        this.isModified = this.timePageReader.isModified();
        this.valuePageReaderList = new ArrayList<ValuePageReader>(valuePageHeaderList.size());
        for (int i = 0; i < valuePageHeaderList.size(); ++i) {
            if (valuePageHeaderList.get(i) != null) {
                ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaderList.get(i), valuePageDataList.get(i), valueDataTypeList.get(i), valueDecoderList.get(i));
                this.valuePageReaderList.add(valuePageReader);
                this.isModified = this.isModified || valuePageReader.isModified();
                continue;
            }
            this.valuePageReaderList.add(null);
        }
        this.globalTimeFilter = globalTimeFilter;
        this.valueCount = this.valuePageReaderList.size();
    }

    AbstractAlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, LazyLoadPageData[] lazyLoadPageDataArray, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        this.timePageReader = new TimePageReader(timePageHeader, timePageData, timeDecoder);
        this.isModified = this.timePageReader.isModified();
        this.valuePageReaderList = new ArrayList<ValuePageReader>(valuePageHeaderList.size());
        for (int i = 0; i < valuePageHeaderList.size(); ++i) {
            if (valuePageHeaderList.get(i) != null) {
                ValuePageReader valuePageReader = new ValuePageReader(valuePageHeaderList.get(i), lazyLoadPageDataArray[i], valueDataTypeList.get(i), valueDecoderList.get(i));
                this.valuePageReaderList.add(valuePageReader);
                this.isModified = this.isModified || valuePageReader.isModified();
                continue;
            }
            this.valuePageReaderList.add(null);
        }
        this.globalTimeFilter = globalTimeFilter;
        this.valueCount = this.valuePageReaderList.size();
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        BatchData pageData = BatchDataFactory.createBatchData(TSDataType.VECTOR, ascending, false);
        int timeIndex = -1;
        Object[] rowValues = new Object[this.valueCount];
        while (this.timePageReader.hasNextTime()) {
            long timestamp = this.timePageReader.nextTime();
            ++timeIndex;
            TsPrimitiveType[] v = new TsPrimitiveType[this.valueCount];
            boolean hasNotNullValues = false;
            for (int i = 0; i < this.valueCount; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                if (pageReader != null) {
                    v[i] = pageReader.nextValue(timestamp, timeIndex);
                    rowValues[i] = v[i] == null ? null : v[i].getValue();
                } else {
                    v[i] = null;
                    rowValues[i] = null;
                }
                if (rowValues[i] == null) continue;
                hasNotNullValues = true;
            }
            if (!this.keepCurrentRow(hasNotNullValues, timestamp, rowValues) || this.timePageReader.isDeleted(timestamp)) continue;
            pageData.putVector(timestamp, v);
        }
        return pageData.flip();
    }

    abstract boolean keepCurrentRow(boolean var1, long var2, Object[] var4);

    protected boolean satisfyRecordFilter(long timestamp, Object[] rowValues) {
        return !(this.globalTimeFilter != null && !this.globalTimeFilter.satisfyRow(timestamp, rowValues) || this.pushDownFilter != null && !this.pushDownFilter.satisfyRow(timestamp, rowValues));
    }

    @Override
    public int getMeasurementCount() {
        return this.valueCount;
    }

    abstract boolean allPageDataSatisfy();

    boolean globalTimeFilterAllSatisfy() {
        return this.globalTimeFilter == null || this.globalTimeFilter.allSatisfy(this);
    }

    boolean pushDownFilterAllSatisfy() {
        return this.pushDownFilter == null || this.pushDownFilter.allSatisfy(this);
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        long[] timeBatch = this.timePageReader.getNextTimeBatch();
        if (this.allPageDataSatisfy()) {
            this.buildResultWithoutAnyFilterAndDelete(timeBatch);
            return this.builder.build();
        }
        boolean[] keepCurrentRow = new boolean[timeBatch.length];
        boolean globalTimeFilterAllSatisfy = this.globalTimeFilterAllSatisfy();
        if (globalTimeFilterAllSatisfy) {
            Arrays.fill(keepCurrentRow, true);
        } else {
            this.updateKeepCurrentRowThroughGlobalTimeFilter(keepCurrentRow, timeBatch);
        }
        if (this.timePageReader.isModified()) {
            this.updateKeepCurrentRowThroughDeletion(keepCurrentRow, timeBatch);
        }
        boolean pushDownFilterAllSatisfy = this.pushDownFilterAllSatisfy();
        this.constructResult(keepCurrentRow, timeBatch, pushDownFilterAllSatisfy);
        TsBlock unFilteredBlock = this.builder.build();
        if (pushDownFilterAllSatisfy) {
            return unFilteredBlock;
        }
        this.builder.reset();
        return TsBlockUtil.applyFilterAndLimitOffsetToTsBlock(unFilteredBlock, this.builder, this.pushDownFilter, this.paginationController);
    }

    private void buildResultWithoutAnyFilterAndDelete(long[] timeBatch) throws IOException {
        if (this.paginationController.hasCurOffset(timeBatch.length)) {
            this.paginationController.consumeOffset(timeBatch.length);
        } else {
            int i;
            int readStartIndex = 0;
            if (this.paginationController.hasCurOffset()) {
                readStartIndex = (int)this.paginationController.getCurOffset();
                this.paginationController.consumeOffset(readStartIndex);
            }
            int readEndIndex = timeBatch.length;
            if (this.paginationController.hasCurLimit() && this.paginationController.getCurLimit() > 0L) {
                readEndIndex = Math.min(readEndIndex, readStartIndex + (int)this.paginationController.getCurLimit());
                this.paginationController.consumeLimit((long)readEndIndex - (long)readStartIndex);
            }
            for (i = readStartIndex; i < readEndIndex; ++i) {
                this.builder.getTimeColumnBuilder().writeLong(timeBatch[i]);
                this.builder.declarePosition();
            }
            for (i = 0; i < this.valueCount; ++i) {
                ValuePageReader pageReader = this.valuePageReaderList.get(i);
                if (pageReader != null) {
                    pageReader.writeColumnBuilderWithNextBatch(readStartIndex, readEndIndex, this.builder.getColumnBuilder(i));
                    continue;
                }
                this.builder.getColumnBuilder(i).appendNull(readEndIndex - readStartIndex);
            }
        }
    }

    abstract void constructResult(boolean[] var1, long[] var2, boolean var3) throws IOException;

    private void updateKeepCurrentRowThroughGlobalTimeFilter(boolean[] keepCurrentRow, long[] timeBatch) {
        int n = timeBatch.length;
        for (int i = 0; i < n; ++i) {
            keepCurrentRow[i] = this.globalTimeFilter.satisfy(timeBatch[i], null);
        }
    }

    private void updateKeepCurrentRowThroughDeletion(boolean[] keepCurrentRow, long[] timeBatch) {
        int n = timeBatch.length;
        for (int i = 0; i < n; ++i) {
            if (!keepCurrentRow[i]) continue;
            keepCurrentRow[i] = !this.timePageReader.isDeleted(timeBatch[i]);
        }
    }

    protected int buildTimeColumn(long[] timeBatch, boolean[] keepCurrentRow, boolean pushDownFilterAllSatisfy) {
        if (pushDownFilterAllSatisfy) {
            return this.buildTimeColumnWithPagination(timeBatch, keepCurrentRow);
        }
        return this.buildTimeColumnWithoutPagination(timeBatch, keepCurrentRow);
    }

    private int buildTimeColumnWithPagination(long[] timeBatch, boolean[] keepCurrentRow) {
        int readEndIndex = timeBatch.length;
        for (int rowIndex = 0; rowIndex < timeBatch.length; ++rowIndex) {
            if (!keepCurrentRow[rowIndex]) continue;
            if (this.paginationController.hasCurOffset()) {
                this.paginationController.consumeOffset();
                keepCurrentRow[rowIndex] = false;
                continue;
            }
            if (this.paginationController.hasCurLimit()) {
                this.builder.getTimeColumnBuilder().writeLong(timeBatch[rowIndex]);
                this.builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = rowIndex;
            break;
        }
        return readEndIndex;
    }

    private int buildTimeColumnWithoutPagination(long[] timeBatch, boolean[] keepCurrentRow) {
        int readEndIndex = 0;
        for (int i = 0; i < timeBatch.length; ++i) {
            if (!keepCurrentRow[i]) continue;
            this.builder.getTimeColumnBuilder().writeLong(timeBatch[i]);
            this.builder.declarePosition();
            readEndIndex = i;
        }
        return readEndIndex + 1;
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.timePageReader.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        ValuePageReader valuePageReader = this.valuePageReaderList.get(measurementIndex);
        return Optional.ofNullable(valuePageReader == null ? null : valuePageReader.getStatistics());
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        long rowCount = this.getTimeStatistics().getCount();
        Optional<Statistics<? extends Serializable>> statistics = this.getMeasurementStatistics(measurementIndex);
        return statistics.map(stat -> stat.hasNullValue(rowCount)).orElse(true);
    }

    @Override
    public void addRecordFilter(Filter filter) {
        this.pushDownFilter = filter;
    }

    @Override
    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
        this.builder = this.paginationController.hasLimit() ? new TsBlockBuilder((int)Math.min(this.paginationController.getCurLimit(), (long)this.timePageReader.getStatistics().getCount()), dataTypes) : new TsBlockBuilder(this.timePageReader.getStatistics().getCount(), dataTypes);
    }

    public TimePageReader getTimePageReader() {
        return this.timePageReader;
    }

    public List<ValuePageReader> getValuePageReaderList() {
        return this.valuePageReaderList;
    }
}

