/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.header.PageHeader;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.reader.IPointReader;
import shaded.org.apache.tsfile.read.reader.page.AbstractAlignedPageReader;
import shaded.org.apache.tsfile.read.reader.page.LazyLoadAlignedPagePointReader;
import shaded.org.apache.tsfile.read.reader.page.LazyLoadPageData;
import shaded.org.apache.tsfile.read.reader.page.ValuePageReader;

public class AlignedPageReader
extends AbstractAlignedPageReader {
    public AlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, List<ByteBuffer> valuePageDataList, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        super(timePageHeader, timePageData, timeDecoder, valuePageHeaderList, valuePageDataList, valueDataTypeList, valueDecoderList, globalTimeFilter);
    }

    public AlignedPageReader(PageHeader timePageHeader, ByteBuffer timePageData, Decoder timeDecoder, List<PageHeader> valuePageHeaderList, LazyLoadPageData[] lazyLoadPageDataArray, List<TSDataType> valueDataTypeList, List<Decoder> valueDecoderList, Filter globalTimeFilter) {
        super(timePageHeader, timePageData, timeDecoder, valuePageHeaderList, lazyLoadPageDataArray, valueDataTypeList, valueDecoderList, globalTimeFilter);
    }

    @Override
    boolean keepCurrentRow(boolean hasNotNullValues, long timestamp, Object[] rowValues) {
        return hasNotNullValues && this.satisfyRecordFilter(timestamp, rowValues);
    }

    @Override
    public boolean timeAllSelected() {
        for (int index = 0; index < this.getMeasurementCount(); ++index) {
            if (this.hasNullValue(index)) continue;
            return true;
        }
        return false;
    }

    public IPointReader getLazyPointReader() throws IOException {
        return new LazyLoadAlignedPagePointReader(this.timePageReader, this.valuePageReaderList);
    }

    @Override
    boolean allPageDataSatisfy() {
        return !this.isModified && this.timeAllSelected() && this.globalTimeFilterAllSatisfy() && this.pushDownFilterAllSatisfy();
    }

    @Override
    void constructResult(boolean[] keepCurrentRow, long[] timeBatch, boolean pushDownFilterAllSatisfy) throws IOException {
        boolean[][] isDeleted = null;
        if ((this.isModified || !this.timeAllSelected()) && this.valueCount != 0) {
            byte[] bitmask = new byte[(timeBatch.length - 1) / 8 + 1];
            Arrays.fill(bitmask, (byte)0);
            isDeleted = new boolean[this.valueCount][timeBatch.length];
            this.fillIsDeletedAndBitMask(timeBatch, isDeleted, bitmask);
            this.updateKeepCurrentRowThroughBitmask(keepCurrentRow, bitmask);
        }
        int readEndIndex = this.buildTimeColumn(timeBatch, keepCurrentRow, pushDownFilterAllSatisfy);
        this.buildValueColumns(readEndIndex, keepCurrentRow, isDeleted);
    }

    private void buildValueColumns(int readEndIndex, boolean[] keepCurrentRow, boolean[][] isDeleted) throws IOException {
        for (int i = 0; i < this.valueCount; ++i) {
            ValuePageReader pageReader = (ValuePageReader)this.valuePageReaderList.get(i);
            if (pageReader != null) {
                if (pageReader.isModified()) {
                    pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow, Objects.requireNonNull(isDeleted)[i]);
                    continue;
                }
                pageReader.writeColumnBuilderWithNextBatch(readEndIndex, this.builder.getColumnBuilder(i), keepCurrentRow);
                continue;
            }
            for (int j = 0; j < readEndIndex; ++j) {
                if (!keepCurrentRow[j]) continue;
                this.builder.getColumnBuilder(i).appendNull();
            }
        }
    }

    private void fillIsDeletedAndBitMask(long[] timeBatch, boolean[][] isDeleted, byte[] bitmask) throws IOException {
        for (int columnIndex = 0; columnIndex < this.valueCount; ++columnIndex) {
            ValuePageReader pageReader = (ValuePageReader)this.valuePageReaderList.get(columnIndex);
            if (pageReader == null) continue;
            byte[] bitmap = pageReader.getBitmap();
            if (pageReader.isModified()) {
                pageReader.fillIsDeleted(timeBatch, isDeleted[columnIndex]);
                this.updateBitmapThroughIsDeleted(bitmap, isDeleted[columnIndex]);
            }
            int n = bitmask.length;
            for (int i = 0; i < n; ++i) {
                bitmask[i] = (byte)(bitmap[i] | bitmask[i]);
            }
        }
    }

    private void updateBitmapThroughIsDeleted(byte[] bitmap, boolean[] isDeleted) {
        int n = isDeleted.length;
        for (int i = 0; i < n; ++i) {
            if (!isDeleted[i]) continue;
            int shift = i % 8;
            bitmap[i / 8] = (byte)(bitmap[i / 8] & ~(128 >>> shift));
        }
    }

    private void updateKeepCurrentRowThroughBitmask(boolean[] keepCurrentRow, byte[] bitmask) {
        int n = bitmask.length;
        for (int i = 0; i < n; ++i) {
            if (bitmask[i] == -1) continue;
            if (bitmask[i] == 0) {
                Arrays.fill(keepCurrentRow, i * 8, Math.min(i * 8 + 8, keepCurrentRow.length), false);
                continue;
            }
            for (int j = 0; j < 8 && i * 8 + j < keepCurrentRow.length; ++j) {
                if ((bitmask[i] & 0xFF & 128 >>> j) != 0) continue;
                keepCurrentRow[i * 8 + j] = false;
            }
        }
    }

    public void setDeleteIntervalList(List<List<TimeRange>> list) {
        for (int i = 0; i < this.valueCount; ++i) {
            if (this.valuePageReaderList.get(i) == null) continue;
            ((ValuePageReader)this.valuePageReaderList.get(i)).setDeleteIntervalList(list.get(i));
        }
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.valuePageReaderList.size() == 1 && this.valuePageReaderList.get(0) != null ? ((ValuePageReader)this.valuePageReaderList.get(0)).getStatistics() : this.timePageReader.getStatistics();
    }
}

