/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.reader.page;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import shaded.org.apache.tsfile.block.column.ColumnBuilder;
import shaded.org.apache.tsfile.encoding.decoder.Decoder;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.header.PageHeader;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.common.BatchData;
import shaded.org.apache.tsfile.read.common.BatchDataFactory;
import shaded.org.apache.tsfile.read.common.TimeRange;
import shaded.org.apache.tsfile.read.common.block.TsBlock;
import shaded.org.apache.tsfile.read.common.block.TsBlockBuilder;
import shaded.org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import shaded.org.apache.tsfile.read.filter.basic.Filter;
import shaded.org.apache.tsfile.read.filter.factory.FilterFactory;
import shaded.org.apache.tsfile.read.reader.IPageReader;
import shaded.org.apache.tsfile.read.reader.page.LazyLoadPageData;
import shaded.org.apache.tsfile.read.reader.series.PaginationController;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.Preconditions;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import shaded.org.apache.tsfile.write.UnSupportedDataTypeException;

public class PageReader
implements IPageReader {
    private final PageHeader pageHeader;
    private final TSDataType dataType;
    private final Decoder valueDecoder;
    private final Decoder timeDecoder;
    private ByteBuffer timeBuffer;
    private ByteBuffer valueBuffer;
    private Filter recordFilter;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;
    private List<TimeRange> deleteIntervalList;
    private int deleteCursor = 0;
    private LazyLoadPageData lazyLoadPageData;

    public PageReader(ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder) {
        this(null, pageData, dataType, valueDecoder, timeDecoder, null);
    }

    public PageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder) {
        this(pageHeader, pageData, dataType, valueDecoder, timeDecoder, null);
    }

    public PageReader(PageHeader pageHeader, ByteBuffer pageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter recordFilter) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.timeDecoder = timeDecoder;
        this.recordFilter = recordFilter;
        this.pageHeader = pageHeader;
        this.splitDataToTimeStampAndValue(pageData);
    }

    public PageReader(PageHeader pageHeader, LazyLoadPageData lazyLoadPageData, TSDataType dataType, Decoder valueDecoder, Decoder timeDecoder, Filter recordFilter) {
        this.dataType = dataType;
        this.valueDecoder = valueDecoder;
        this.timeDecoder = timeDecoder;
        this.recordFilter = recordFilter;
        this.pageHeader = pageHeader;
        this.lazyLoadPageData = lazyLoadPageData;
    }

    private void splitDataToTimeStampAndValue(ByteBuffer pageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt(pageData);
        this.timeBuffer = pageData.slice();
        this.timeBuffer.limit(timeBufferLength);
        this.valueBuffer = pageData.slice();
        this.valueBuffer.position(timeBufferLength);
    }

    private void uncompressDataIfNecessary() throws IOException {
        if (this.lazyLoadPageData != null && (this.timeBuffer == null || this.valueBuffer == null)) {
            this.splitDataToTimeStampAndValue(this.lazyLoadPageData.uncompressPageData(this.pageHeader));
            this.lazyLoadPageData = null;
        }
    }

    @Override
    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        boolean allSatisfy;
        this.uncompressDataIfNecessary();
        BatchData pageData = BatchDataFactory.createBatchData(this.dataType, ascending, false);
        boolean bl = allSatisfy = this.recordFilter == null || this.recordFilter.allSatisfy(this);
        block8: while (this.timeDecoder.hasNext(this.timeBuffer)) {
            long timestamp = this.timeDecoder.readLong(this.timeBuffer);
            switch (this.dataType) {
                case BOOLEAN: {
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyBoolean(timestamp, aBoolean)) continue block8;
                    pageData.putBoolean(timestamp, aBoolean);
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyInteger(timestamp, anInt)) continue block8;
                    pageData.putInt(timestamp, anInt);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyLong(timestamp, aLong)) continue block8;
                    pageData.putLong(timestamp, aLong);
                    continue block8;
                }
                case FLOAT: {
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyFloat(timestamp, aFloat)) continue block8;
                    pageData.putFloat(timestamp, aFloat);
                    continue block8;
                }
                case DOUBLE: {
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyDouble(timestamp, aDouble)) continue block8;
                    pageData.putDouble(timestamp, aDouble);
                    continue block8;
                }
                case TEXT: 
                case BLOB: 
                case STRING: {
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyBinary(timestamp, aBinary)) continue block8;
                    pageData.putBinary(timestamp, aBinary);
                    continue block8;
                }
            }
            throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
        }
        return pageData.flip();
    }

    @Override
    public TsBlock getAllSatisfiedData() throws IOException {
        this.uncompressDataIfNecessary();
        int initialExpectedEntries = this.pageHeader.getStatistics().getCount();
        if (this.paginationController.hasLimit()) {
            initialExpectedEntries = (int)Math.min((long)initialExpectedEntries, this.paginationController.getCurLimit());
        }
        TsBlockBuilder builder = new TsBlockBuilder(initialExpectedEntries, Collections.singletonList(this.dataType));
        TimeColumnBuilder timeBuilder = builder.getTimeColumnBuilder();
        ColumnBuilder valueBuilder = builder.getColumnBuilder(0);
        boolean allSatisfy = this.recordFilter == null || this.recordFilter.allSatisfy(this);
        block0 : switch (this.dataType) {
            case BOOLEAN: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    boolean aBoolean = this.valueDecoder.readBoolean(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyBoolean(timestamp, aBoolean)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeBoolean(aBoolean);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case INT32: 
            case DATE: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    int anInt = this.valueDecoder.readInt(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyInteger(timestamp, anInt)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeInt(anInt);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    long aLong = this.valueDecoder.readLong(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyLong(timestamp, aLong)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeLong(aLong);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case FLOAT: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    float aFloat = this.valueDecoder.readFloat(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyFloat(timestamp, aFloat)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeFloat(aFloat);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case DOUBLE: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    double aDouble = this.valueDecoder.readDouble(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyDouble(timestamp, aDouble)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeDouble(aDouble);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                while (this.timeDecoder.hasNext(this.timeBuffer)) {
                    long timestamp = this.timeDecoder.readLong(this.timeBuffer);
                    Binary aBinary = this.valueDecoder.readBinary(this.valueBuffer);
                    if (this.isDeleted(timestamp) || !allSatisfy && !this.recordFilter.satisfyBinary(timestamp, aBinary)) continue;
                    if (this.paginationController.hasCurOffset()) {
                        this.paginationController.consumeOffset();
                        continue;
                    }
                    if (!this.paginationController.hasCurLimit()) break block0;
                    timeBuilder.writeLong(timestamp);
                    valueBuilder.writeBinary(aBinary);
                    builder.declarePosition();
                    this.paginationController.consumeLimit();
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf((Object)this.dataType));
            }
        }
        return builder.build();
    }

    @Override
    public Statistics<? extends Serializable> getStatistics() {
        return this.pageHeader.getStatistics();
    }

    @Override
    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.getStatistics();
    }

    @Override
    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        Preconditions.checkArgument(measurementIndex == 0, "Non-aligned page only has one measurement, but measurementIndex is " + measurementIndex);
        return Optional.ofNullable(this.getStatistics());
    }

    @Override
    public boolean hasNullValue(int measurementIndex) {
        return false;
    }

    @Override
    public void addRecordFilter(Filter filter) {
        this.recordFilter = FilterFactory.and(this.recordFilter, filter);
    }

    @Override
    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public void setDeleteIntervalList(List<TimeRange> list) {
        this.deleteIntervalList = list;
    }

    public List<TimeRange> getDeleteIntervalList() {
        return this.deleteIntervalList;
    }

    @Override
    public boolean isModified() {
        return this.pageHeader.isModified();
    }

    @Override
    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
    }

    protected boolean isDeleted(long timestamp) {
        while (this.deleteIntervalList != null && this.deleteCursor < this.deleteIntervalList.size()) {
            if (this.deleteIntervalList.get(this.deleteCursor).contains(timestamp)) {
                return true;
            }
            if (this.deleteIntervalList.get(this.deleteCursor).getMax() < timestamp) {
                ++this.deleteCursor;
                continue;
            }
            return false;
        }
        return false;
    }
}

