/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.read.v4;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.annotations.TsFileApi;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.exception.read.ReadProcessException;
import shaded.org.apache.tsfile.exception.write.NoMeasurementException;
import shaded.org.apache.tsfile.exception.write.NoTableException;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.read.controller.CachedChunkLoaderImpl;
import shaded.org.apache.tsfile.read.controller.IChunkLoader;
import shaded.org.apache.tsfile.read.controller.IMetadataQuerier;
import shaded.org.apache.tsfile.read.controller.MetadataQuerierByFileImpl;
import shaded.org.apache.tsfile.read.expression.ExpressionTree;
import shaded.org.apache.tsfile.read.query.dataset.ResultSet;
import shaded.org.apache.tsfile.read.query.dataset.TableResultSet;
import shaded.org.apache.tsfile.read.query.executor.TableQueryExecutor;
import shaded.org.apache.tsfile.read.reader.block.TsBlockReader;
import shaded.org.apache.tsfile.read.v4.ITsFileReader;

public class DeviceTableModelReader
implements ITsFileReader {
    protected TsFileSequenceReader fileReader;
    protected IMetadataQuerier metadataQuerier;
    protected IChunkLoader chunkLoader;
    protected TableQueryExecutor queryExecutor;
    private static final Logger LOG = LoggerFactory.getLogger(DeviceTableModelReader.class);

    public DeviceTableModelReader(File file) throws IOException {
        this.fileReader = new TsFileSequenceReader(file.getPath());
        this.fileReader.setEnableCacheTableSchemaMap();
        this.metadataQuerier = new MetadataQuerierByFileImpl(this.fileReader);
        this.chunkLoader = new CachedChunkLoaderImpl(this.fileReader);
        this.queryExecutor = new TableQueryExecutor(this.metadataQuerier, this.chunkLoader, TableQueryExecutor.TableQueryOrdering.DEVICE);
    }

    @Override
    @TsFileApi
    public List<TableSchema> getAllTableSchema() throws IOException {
        Map<String, TableSchema> tableSchemaMap = this.fileReader.getTableSchemaMap();
        return new ArrayList<TableSchema>(tableSchemaMap.values());
    }

    @Override
    @TsFileApi
    public Optional<TableSchema> getTableSchemas(String tableName) throws IOException {
        Map<String, TableSchema> tableSchemaMap = this.fileReader.getTableSchemaMap();
        return Optional.ofNullable(tableSchemaMap.get(tableName.toLowerCase()));
    }

    @Override
    @TsFileApi
    public ResultSet query(String tableName, List<String> columnNames, long startTime, long endTime) throws IOException, NoTableException, NoMeasurementException, ReadProcessException {
        String lowerCaseTableName = tableName.toLowerCase();
        TableSchema tableSchema = this.fileReader.getTableSchemaMap().get(lowerCaseTableName);
        if (tableSchema == null) {
            throw new NoTableException(tableName);
        }
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(columnNames.size());
        ArrayList<String> lowerCaseColumnNames = new ArrayList<String>(columnNames.size());
        for (String columnName : columnNames) {
            Map<String, Integer> column2IndexMap = tableSchema.buildColumnPosIndex();
            Integer columnIndex = column2IndexMap.get(columnName.toLowerCase());
            if (columnIndex == null) {
                throw new NoMeasurementException(columnName);
            }
            lowerCaseColumnNames.add(columnName.toLowerCase());
            dataTypeList.add(tableSchema.getColumnSchemas().get(columnIndex).getType());
        }
        TsBlockReader tsBlockReader = this.queryExecutor.query(lowerCaseTableName, lowerCaseColumnNames, new ExpressionTree.TimeBetweenAnd(startTime, endTime), null, null);
        return new TableResultSet(tsBlockReader, columnNames, dataTypeList);
    }

    @Override
    public void close() {
        try {
            this.fileReader.close();
        }
        catch (IOException e) {
            LOG.warn("Meet exception when close file reader: ", e);
        }
    }
}

