/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.utils;

import java.util.Arrays;
import java.util.Objects;

public class BitMap {
    private static final byte[] BIT_UTIL = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private static final byte[] UNMARK_BIT_UTIL = new byte[]{-2, -3, -5, -9, -17, -33, -65, 127};
    private byte[] bits;
    private int size;

    public BitMap(int size) {
        this.size = size;
        this.bits = new byte[BitMap.getSizeOfBytes(size)];
    }

    public BitMap(int size, byte[] bits) {
        this.size = size;
        this.bits = bits;
    }

    public byte[] getByteArray() {
        return this.bits;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isMarked(int position) {
        return (this.bits[position / 8] & BIT_UTIL[position % 8]) != 0;
    }

    public void markAll() {
        Arrays.fill(this.bits, (byte)-1);
    }

    public void mark(int position) {
        int n = position / 8;
        this.bits[n] = (byte)(this.bits[n] | BIT_UTIL[position % 8]);
    }

    public void markRange(int startPosition, int length) {
        if (length <= 0) {
            return;
        }
        if (startPosition < 0 || startPosition + length > this.size) {
            throw new IndexOutOfBoundsException("startPosition " + startPosition + " + length " + length + " is out of range " + this.size);
        }
        int byte0 = startPosition >>> 3;
        int bitEnd = startPosition + length - 1;
        int byte1 = bitEnd >>> 3;
        if (byte0 == byte1) {
            int n = byte0;
            this.bits[n] = (byte)(this.bits[n] | (byte)((1 << length) - 1 << (startPosition & 7)));
            return;
        }
        int n = byte0++;
        this.bits[n] = (byte)(this.bits[n] | (byte)(255 << (startPosition & 7)));
        while (byte0 < byte1) {
            this.bits[byte0++] = -1;
        }
        int n2 = byte1;
        this.bits[n2] = (byte)(this.bits[n2] | (byte)(255 >>> 7 - (bitEnd & 7)));
    }

    public void reset() {
        Arrays.fill(this.bits, (byte)0);
    }

    public void unmark(int position) {
        int n = position / 8;
        this.bits[n] = (byte)(this.bits[n] & UNMARK_BIT_UTIL[position % 8]);
    }

    public void unmarkRange(int startPosition, int length) {
        if (length <= 0) {
            return;
        }
        if (startPosition < 0 || startPosition + length > this.size) {
            throw new IndexOutOfBoundsException("startPosition " + startPosition + " + length " + length + " is out of range " + this.size);
        }
        int byte0 = startPosition >>> 3;
        int bitEnd = startPosition + length - 1;
        int byte1 = bitEnd >>> 3;
        if (byte0 == byte1) {
            int n = byte0;
            this.bits[n] = (byte)(this.bits[n] & (byte)(~((1 << length) - 1 << (startPosition & 7))));
            return;
        }
        int n = byte0++;
        this.bits[n] = (byte)(this.bits[n] & (byte)(~(255 << (startPosition & 7))));
        while (byte0 < byte1) {
            this.bits[byte0++] = 0;
        }
        int n2 = byte1;
        this.bits[n2] = (byte)(this.bits[n2] & (byte)(255 << (bitEnd & 7) + 1));
    }

    public void merge(BitMap src, int srcStart, int destStart, int len) {
        int size;
        if (len <= 0) {
            return;
        }
        if (srcStart < 0 || destStart < 0 || srcStart + len > src.size || destStart + len > this.size) {
            throw new IndexOutOfBoundsException();
        }
        int dstBit = destStart & 7;
        for (int done = 0; done < len; done += size) {
            size = Math.min(len - done, 64);
            long bits = this.extractBits(src.bits, srcStart + done, size);
            int destStartByte = destStart + done >>> 3;
            int n = destStartByte++;
            this.bits[n] = (byte)(this.bits[n] | (byte)(bits << dstBit & 0xFFL));
            bits >>>= 8 - dstBit;
            while (bits > 0L) {
                int n2 = destStartByte++;
                this.bits[n2] = (byte)(this.bits[n2] | (byte)(bits & 0xFFL));
                bits >>>= 8;
            }
        }
    }

    private long extractBits(byte[] buf, int off, int len) {
        int start = off >>> 3;
        long val = ((long)buf[start++] & 0xFFL) >>> (off & 7);
        for (int size = 8 - (off & 7); size < len; size += 8) {
            val |= ((long)buf[start++] & 0xFFL) << size;
        }
        return val & -1L >>> 64 - len;
    }

    public boolean isAllUnmarked() {
        int j;
        for (j = 0; j < this.size / 8; ++j) {
            if (this.bits[j] == 0) continue;
            return false;
        }
        for (j = 0; j < this.size % 8; ++j) {
            if ((this.bits[this.size / 8] & BIT_UTIL[j]) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isAllUnmarked(int rangeSize) {
        byte mask;
        for (int j = 0; j < rangeSize / 8; ++j) {
            if (this.bits[j] == 0) continue;
            return false;
        }
        int remainingBits = rangeSize % 8;
        return remainingBits <= 0 || (this.bits[rangeSize / 8] & (mask = (byte)(255 >> 8 - remainingBits))) == 0;
    }

    public boolean isAllMarked() {
        int j;
        for (j = 0; j < this.size / 8; ++j) {
            if (this.bits[j] == -1) continue;
            return false;
        }
        for (j = 0; j < this.size % 8; ++j) {
            if ((this.bits[this.size / 8] & BIT_UTIL[j]) != 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            res.append(this.isMarked(i) ? 1 : 0);
        }
        return res.toString();
    }

    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + Arrays.hashCode(this.bits);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BitMap)) {
            return false;
        }
        BitMap other = (BitMap)obj;
        return this.size == other.size && Arrays.equals(this.bits, other.bits);
    }

    public boolean equalsInRange(Object obj, int rangeSize) {
        byte mask;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BitMap)) {
            return false;
        }
        BitMap other = (BitMap)obj;
        if (rangeSize > this.size || rangeSize > other.size) {
            throw new IllegalArgumentException("range size " + rangeSize + " should <= the minimal bitmap size " + Math.min(this.size, other.size));
        }
        int byteSize = rangeSize / 8;
        for (int i = 0; i < byteSize; ++i) {
            if (this.bits[i] == other.bits[i]) continue;
            return false;
        }
        int remainingBits = rangeSize % 8;
        return remainingBits <= 0 || (this.bits[byteSize] & (mask = (byte)(255 >> 8 - remainingBits))) == (other.bits[byteSize] & mask);
    }

    public BitMap clone() {
        byte[] cloneBytes = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, cloneBytes, 0, this.bits.length);
        return new BitMap(this.size, cloneBytes);
    }

    public static void copyOfRange(BitMap src, int srcPos, BitMap dest, int destPos, int length) {
        if (srcPos + length > src.size) {
            throw new IndexOutOfBoundsException(srcPos + length - 1 + " is out of src range " + src.size);
        }
        if (destPos + length > dest.size) {
            throw new IndexOutOfBoundsException(destPos + length - 1 + " is out of dest range " + dest.size);
        }
        for (int i = 0; i < length; ++i) {
            if (src.isMarked(srcPos + i)) {
                dest.mark(destPos + i);
                continue;
            }
            dest.unmark(destPos + i);
        }
    }

    public BitMap getRegion(int positionOffset, int length) {
        BitMap newBitMap = new BitMap(length);
        BitMap.copyOfRange(this, positionOffset, newBitMap, 0, length);
        return newBitMap;
    }

    public static int getSizeOfBytes(int size) {
        return size / 8 + 1;
    }

    public byte[] getTruncatedByteArray(int size) {
        return Arrays.copyOf(this.bits, BitMap.getSizeOfBytes(size));
    }

    public void append(BitMap another, int position, int length) {
        for (int i = 0; i < length; ++i) {
            if (another.isMarked(i)) {
                this.mark(position + i);
                continue;
            }
            this.unmark(position + i);
        }
    }

    public void extend(int newSize) {
        if (this.size >= newSize) {
            return;
        }
        this.bits = Arrays.copyOf(this.bits, BitMap.getSizeOfBytes(newSize));
        this.size = newSize;
    }
}

