/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Objects;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.utils.Murmur128Hash;
import shaded.org.apache.tsfile.utils.RamUsageEstimator;
import shaded.org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class BloomFilter {
    private static final int INSTANCE_SIZE = (int)(RamUsageEstimator.shallowSizeOfInstance(BloomFilter.class) + RamUsageEstimator.shallowSizeOfInstance(BitSet.class));
    private static final int MINIMAL_SIZE = 256;
    private static final int MAXIMAL_HASH_FUNCTION_SIZE = 8;
    private static final int[] SEEDS = new int[]{5, 7, 11, 19, 31, 37, 43, 59};
    private final int size;
    private final int hashFunctionSize;
    private final BitSet bits;

    private BloomFilter(byte[] bytes, int size, int hashFunctionSize) {
        this.size = size;
        this.hashFunctionSize = hashFunctionSize;
        this.bits = BitSet.valueOf(bytes);
    }

    private BloomFilter(int size, int hashFunctionSize) {
        this.size = size;
        this.hashFunctionSize = hashFunctionSize;
        this.bits = new BitSet(size);
    }

    public static BloomFilter getEmptyBloomFilter(double errorPercent, int numOfString) {
        errorPercent = Math.max(errorPercent, 0.01);
        errorPercent = Math.min(errorPercent, 0.1);
        double ln2 = Math.log(2.0);
        int size = (int)((double)(-numOfString) * Math.log(errorPercent) / ln2 / ln2) + 1;
        int hashFunctionSize = (int)(-Math.log(errorPercent) / ln2) + 1;
        return new BloomFilter(Math.max(256, size), Math.min(8, hashFunctionSize));
    }

    public static BloomFilter buildBloomFilter(byte[] bytes, int size, int hashFunctionSize) {
        return new BloomFilter(bytes, size, Math.min(8, hashFunctionSize));
    }

    public int getHashFunctionSize() {
        return this.hashFunctionSize;
    }

    public int getSize() {
        return this.size;
    }

    public void add(Path path) {
        for (int i = 0; i < this.hashFunctionSize; ++i) {
            this.bits.set(BloomFilter.hash(path.getFullPath(), this.size, SEEDS[i]), true);
        }
    }

    public void add(String value) {
        for (int i = 0; i < this.hashFunctionSize; ++i) {
            this.bits.set(BloomFilter.hash(value, this.size, SEEDS[i]), true);
        }
    }

    public boolean contains(Path value) {
        if (value == null) {
            return false;
        }
        boolean ret = true;
        int index = 0;
        while (ret && index < this.hashFunctionSize) {
            ret = this.bits.get(BloomFilter.hash(value.getFullPath(), this.size, SEEDS[index++]));
        }
        return ret;
    }

    public boolean contains(String value) {
        if (value == null) {
            return false;
        }
        boolean ret = true;
        int index = 0;
        while (ret && index < this.hashFunctionSize) {
            ret = this.bits.get(BloomFilter.hash(value, this.size, SEEDS[index++]));
        }
        return ret;
    }

    public byte[] serialize() {
        return this.bits.toByteArray();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + RamUsageEstimator.sizeOfLongArray(this.bits.size() / 64);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomFilter that = (BloomFilter)o;
        return this.size == that.size && this.hashFunctionSize == that.hashFunctionSize && Objects.equals(this.bits, that.bits);
    }

    public int hashCode() {
        return Objects.hash(this.size, this.hashFunctionSize, this.bits);
    }

    private static int hash(String value, int cap, int seed) {
        int res = Murmur128Hash.hash(value, seed);
        if (res == Integer.MIN_VALUE) {
            res = 0;
        }
        return Math.abs(res) % cap;
    }

    public int serialize(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byte[] bytes = this.serialize();
        byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(bytes.length, outputStream);
        if (bytes.length > 0) {
            outputStream.write(bytes);
            byteLen += bytes.length;
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.getSize(), outputStream);
            byteLen += ReadWriteForEncodingUtils.writeUnsignedVarInt(this.getHashFunctionSize(), outputStream);
        }
        return byteLen;
    }

    public static BloomFilter deserialize(ByteBuffer buffer) {
        byte[] bytes = ReadWriteIOUtils.readByteBufferWithSelfDescriptionLength(buffer);
        if (bytes.length != 0) {
            int filterSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            int hashFunctionSize = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
            return BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize);
        }
        return null;
    }
}

