/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class Loader {
    private Loader() {
    }

    public static Set<URI> getResources(String resource, ClassLoader classLoader) throws IOException, URISyntaxException {
        HashSet<URI> uriSet = new HashSet<URI>();
        Enumeration<URL> urlEnum = classLoader.getResources(resource);
        while (urlEnum.hasMoreElements()) {
            uriSet.add(urlEnum.nextElement().toURI());
        }
        return uriSet;
    }

    public static URL getResource(String resource, ClassLoader classLoader) {
        return classLoader.getResource(resource);
    }

    public static ClassLoader getClassLoaderOfObject(Object o) {
        if (o == null) {
            throw new NullPointerException("Input object cannot be null");
        }
        return Loader.getClassLoaderOfClass(o.getClass());
    }

    public static ClassLoader getClassLoaderOfClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
    }
}

