/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.utils;

import java.io.File;
import java.io.IOException;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;

public class TsFileUtils {
    public static boolean isTsFileComplete(File file) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), false);){
            boolean bl = reader.isComplete();
            return bl;
        }
    }

    public static long getTimePartition(File tsFile) {
        File timePartitionFolder = tsFile.getParentFile();
        return Long.parseLong(timePartitionFolder.getName());
    }

    public static int getDataRegionId(File tsFile) {
        File dataRegionFolder = tsFile.getParentFile().getParentFile();
        return Integer.parseInt(dataRegionFolder.getName());
    }

    public static String getStorageGroup(File tsFile) {
        File vsgFolder = tsFile.getParentFile().getParentFile().getParentFile();
        return vsgFolder.getName();
    }

    public static boolean isSequence(File tsFile) {
        File folder = tsFile.getParentFile().getParentFile().getParentFile().getParentFile();
        return folder.getName().equals("sequence");
    }
}

