/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.utils;

import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.write.record.Tablet;

public class WriteUtils {
    public static List<Pair<IDeviceID, Integer>> splitTabletByDevice(Tablet tablet) {
        ArrayList<Pair<IDeviceID, Integer>> result = new ArrayList<Pair<IDeviceID, Integer>>();
        IDeviceID lastDeviceID = null;
        for (int i = 0; i < tablet.getRowSize(); ++i) {
            IDeviceID currDeviceID = tablet.getDeviceID(i);
            if (currDeviceID.equals(lastDeviceID)) continue;
            if (lastDeviceID != null) {
                result.add(new Pair<IDeviceID, Integer>(lastDeviceID, i));
            }
            lastDeviceID = currDeviceID;
        }
        result.add(new Pair<Object, Integer>(lastDeviceID, tablet.getRowSize()));
        return result;
    }

    public static int compareStrings(String a, String b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    @FunctionalInterface
    public static interface TabletAddValueFunction {
        public void addValue(Tablet var1, int var2, int var3);
    }
}

