/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.annotations.TsFileApi;
import shaded.org.apache.tsfile.common.conf.TSFileConfig;
import shaded.org.apache.tsfile.common.conf.TSFileDescriptor;
import shaded.org.apache.tsfile.encrypt.EncryptParameter;
import shaded.org.apache.tsfile.encrypt.IEncryptor;
import shaded.org.apache.tsfile.enums.ColumnCategory;
import shaded.org.apache.tsfile.exception.encrypt.EncryptException;
import shaded.org.apache.tsfile.exception.write.ConflictDataTypeException;
import shaded.org.apache.tsfile.exception.write.NoDeviceException;
import shaded.org.apache.tsfile.exception.write.NoMeasurementException;
import shaded.org.apache.tsfile.exception.write.NoTableException;
import shaded.org.apache.tsfile.exception.write.WriteProcessException;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.utils.MeasurementGroup;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.WriteUtils;
import shaded.org.apache.tsfile.write.chunk.AlignedChunkGroupWriterImpl;
import shaded.org.apache.tsfile.write.chunk.IChunkGroupWriter;
import shaded.org.apache.tsfile.write.chunk.NonAlignedChunkGroupWriterImpl;
import shaded.org.apache.tsfile.write.chunk.TableChunkGroupWriterImpl;
import shaded.org.apache.tsfile.write.record.TSRecord;
import shaded.org.apache.tsfile.write.record.Tablet;
import shaded.org.apache.tsfile.write.record.datapoint.DataPoint;
import shaded.org.apache.tsfile.write.schema.IMeasurementSchema;
import shaded.org.apache.tsfile.write.schema.Schema;
import shaded.org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import shaded.org.apache.tsfile.write.writer.TsFileIOWriter;
import shaded.org.apache.tsfile.write.writer.TsFileOutput;

public class TsFileWriter
implements AutoCloseable {
    protected static final TSFileConfig config = TSFileDescriptor.getInstance().getConfig();
    private static final Logger LOG = LoggerFactory.getLogger(TsFileWriter.class);
    private final TsFileIOWriter fileWriter;
    private EncryptParameter encryptParam;
    private final int pageSize;
    private long recordCount = 0L;
    private Map<IDeviceID, List<String>> flushedMeasurementsInDeviceMap = new HashMap<IDeviceID, List<String>>();
    private Map<IDeviceID, Long> alignedDeviceLastTimeMap = new HashMap<IDeviceID, Long>();
    private Map<IDeviceID, Map<String, Long>> nonAlignedTimeseriesLastTimeMap = new HashMap<IDeviceID, Map<String, Long>>();
    private boolean isUnseq = false;
    private Map<IDeviceID, IChunkGroupWriter> groupWriters = new TreeMap<IDeviceID, IChunkGroupWriter>();
    private long recordCountForNextMemCheck = 100L;
    private long chunkGroupSizeThreshold;
    private boolean isTableWriteAligned = true;

    @TsFileApi
    public TsFileWriter(File file) throws IOException {
        this(new TsFileIOWriter(file), new Schema(), TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(TsFileIOWriter fileWriter) throws IOException {
        this(fileWriter, new Schema(), TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(File file, Schema schema) throws IOException {
        this(new TsFileIOWriter(file), schema, TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(TsFileOutput output, Schema schema) throws IOException {
        this(new TsFileIOWriter(output), schema, TSFileDescriptor.getInstance().getConfig());
    }

    public TsFileWriter(File file, Schema schema, TSFileConfig conf) throws IOException {
        this(new TsFileIOWriter(file), schema, conf);
    }

    protected TsFileWriter(TsFileIOWriter fileWriter, Schema schema, TSFileConfig conf) throws IOException {
        byte[] encryptKey;
        byte[] dataEncryptKey;
        String encryptType;
        String encryptLevel;
        if (!fileWriter.canWrite()) {
            throw new IOException("the given file Writer does not support writing any more. Maybe it is an complete TsFile");
        }
        this.fileWriter = fileWriter;
        if (fileWriter instanceof RestorableTsFileIOWriter) {
            schema = ((RestorableTsFileIOWriter)fileWriter).getKnownSchema();
        }
        fileWriter.setSchema(schema);
        this.pageSize = conf.getPageSizeInByte();
        this.chunkGroupSizeThreshold = conf.getGroupSizeInByte();
        config.setTSFileStorageFs(conf.getTSFileStorageFs());
        if ((long)this.pageSize >= this.chunkGroupSizeThreshold) {
            LOG.warn("TsFile's page size {} is greater than chunk group size {}, please enlarge the chunk group size or decrease page size. ", (Object)this.pageSize, (Object)this.chunkGroupSizeThreshold);
        }
        if (!Objects.equals(config.getEncryptType(), "UNENCRYPTED") && !Objects.equals(config.getEncryptType(), "shaded.org.apache.tsfile.encrypt.UNENCRYPTED")) {
            MessageDigest md;
            encryptLevel = "2";
            encryptType = config.getEncryptType();
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new EncryptException("SHA-256 algorithm not found while using SHA-256 to generate data key", e);
            }
            md.update("IoTDB is the best".getBytes());
            md.update(config.getEncryptKey());
            dataEncryptKey = Arrays.copyOfRange(md.digest(), 0, 16);
            encryptKey = IEncryptor.getEncryptor(config.getEncryptType(), config.getEncryptKey()).encrypt(dataEncryptKey);
        } else {
            encryptLevel = "0";
            encryptType = "shaded.org.apache.tsfile.encrypt.UNENCRYPTED";
            encryptKey = null;
            dataEncryptKey = null;
        }
        this.encryptParam = new EncryptParameter(encryptType, dataEncryptKey);
        if (encryptKey != null) {
            StringBuilder valueStr = new StringBuilder();
            for (void var12_13 : encryptKey) {
                valueStr.append((int)var12_13).append(",");
            }
            valueStr.deleteCharAt(valueStr.length() - 1);
            String str = valueStr.toString();
            fileWriter.setEncryptParam(encryptLevel, encryptType, str);
        } else {
            fileWriter.setEncryptParam(encryptLevel, encryptType, "");
        }
    }

    public void setChunkGroupSizeThreshold(long chunkGroupSizeThreshold) {
        this.chunkGroupSizeThreshold = chunkGroupSizeThreshold;
    }

    public void registerSchemaTemplate(String templateName, Map<String, IMeasurementSchema> template, boolean isAligned) {
        this.getSchema().registerSchemaTemplate(templateName, new MeasurementGroup(isAligned, template));
    }

    public void registerDevice(String deviceIdString, String templateName) throws WriteProcessException {
        IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdString);
        if (!this.getSchema().getSchemaTemplates().containsKey(templateName)) {
            throw new WriteProcessException("given template is not existed! " + templateName);
        }
        if (this.getSchema().getRegisteredTimeseriesMap().containsKey(deviceID)) {
            throw new WriteProcessException("this device " + deviceIdString + " has been registered, you can only use registerDevice method to register empty device.");
        }
        this.getSchema().registerDevice(deviceID, templateName);
    }

    @TsFileApi
    public void registerTimeseries(String deviceId, IMeasurementSchema measurementSchema) throws WriteProcessException {
        this.registerTimeseries(IDeviceID.Factory.DEFAULT_FACTORY.create(deviceId), measurementSchema);
    }

    @Deprecated
    public void registerTimeseries(Path devicePath, IMeasurementSchema measurementSchema) throws WriteProcessException {
        this.registerTimeseries(devicePath.getIDeviceID(), measurementSchema);
    }

    @TsFileApi
    public void registerTimeseries(IDeviceID deviceID, IMeasurementSchema measurementSchema) throws WriteProcessException {
        MeasurementGroup measurementGroup;
        if (this.getSchema().containsDevice(deviceID)) {
            measurementGroup = this.getSchema().getSeriesSchema(deviceID);
            if (measurementGroup.isAligned()) {
                throw new WriteProcessException("given device " + deviceID + " has been registered for aligned timeseries.");
            }
            if (measurementGroup.getMeasurementSchemaMap().containsKey(measurementSchema.getMeasurementName())) {
                throw new WriteProcessException("given nonAligned timeseries " + deviceID + "." + measurementSchema.getMeasurementName() + " has been registered.");
            }
        } else {
            measurementGroup = new MeasurementGroup(false);
        }
        measurementGroup.getMeasurementSchemaMap().put(measurementSchema.getMeasurementName(), measurementSchema);
        this.getSchema().registerMeasurementGroup(deviceID, measurementGroup);
    }

    @Deprecated
    public void registerTimeseries(Path devicePath, List<IMeasurementSchema> measurementSchemas) {
        for (IMeasurementSchema schema : measurementSchemas) {
            try {
                this.registerTimeseries(devicePath.getIDeviceID(), schema);
            }
            catch (WriteProcessException e) {
                LOG.warn(e.getMessage());
            }
        }
    }

    @TsFileApi
    public void registerAlignedTimeseries(String deviceId, List<IMeasurementSchema> measurementSchemas) throws WriteProcessException {
        this.registerAlignedTimeseries(IDeviceID.Factory.DEFAULT_FACTORY.create(deviceId), measurementSchemas);
    }

    public void registerAlignedTimeseries(Path devicePath, List<IMeasurementSchema> measurementSchemas) throws WriteProcessException {
        this.registerAlignedTimeseries(devicePath.getIDeviceID(), measurementSchemas);
    }

    @TsFileApi
    public void registerAlignedTimeseries(IDeviceID deviceID, List<IMeasurementSchema> measurementSchemas) throws WriteProcessException {
        if (this.getSchema().containsDevice(deviceID)) {
            if (this.getSchema().getSeriesSchema(deviceID).isAligned()) {
                throw new WriteProcessException("given device " + deviceID + " has been registered for aligned timeseries and should not be expanded.");
            }
            throw new WriteProcessException("given device " + deviceID + " has been registered for nonAligned timeseries.");
        }
        MeasurementGroup measurementGroup = new MeasurementGroup(true);
        measurementSchemas.forEach(measurementSchema -> measurementGroup.getMeasurementSchemaMap().put(measurementSchema.getMeasurementName(), (IMeasurementSchema)measurementSchema));
        this.getSchema().registerMeasurementGroup(deviceID, measurementGroup);
    }

    private boolean checkIsTimeseriesExist(TSRecord record, boolean isAligned) throws WriteProcessException, IOException {
        IDeviceID deviceID = record.deviceId;
        IChunkGroupWriter groupWriter = this.tryToInitialGroupWriter(deviceID, isAligned, false);
        if (this.getSchema().containsDevice(deviceID)) {
            List<IMeasurementSchema> measurementSchemas = this.checkIsAllMeasurementsInGroup(record.dataPointList, this.getSchema().getSeriesSchema(deviceID), isAligned);
            if (isAligned) {
                for (IMeasurementSchema s : measurementSchemas) {
                    if (!this.flushedMeasurementsInDeviceMap.containsKey(deviceID) || this.flushedMeasurementsInDeviceMap.get(deviceID).contains(s.getMeasurementName())) continue;
                    throw new WriteProcessException("TsFile has flushed chunk group and should not add new measurement " + s.getMeasurementName() + " in device " + deviceID);
                }
            }
            groupWriter.tryToAddSeriesWriter(measurementSchemas);
        } else if (this.getSchema().getSchemaTemplates() != null && this.getSchema().getSchemaTemplates().size() == 1) {
            MeasurementGroup measurementGroup = this.getSchema().getSchemaTemplates().entrySet().iterator().next().getValue();
            List<IMeasurementSchema> measurementSchemas = this.checkIsAllMeasurementsInGroup(record.dataPointList, measurementGroup, isAligned);
            groupWriter.tryToAddSeriesWriter(measurementSchemas);
        } else {
            throw new NoDeviceException(deviceID.toString());
        }
        return true;
    }

    private void checkIsTableExistAndSetColumnCategoryList(Tablet tablet) throws WriteProcessException {
        String tableName = tablet.getTableName();
        TableSchema tableSchema = this.getSchema().getTableSchemaMap().get(tableName);
        if (tableSchema == null) {
            throw new NoTableException(tableName);
        }
        ArrayList<ColumnCategory> columnCategoryListForTablet = new ArrayList<ColumnCategory>(tablet.getSchemas().size());
        for (IMeasurementSchema writingColumnSchema : tablet.getSchemas()) {
            int columnIndex = tableSchema.findColumnIndex(writingColumnSchema.getMeasurementName());
            if (columnIndex < 0) {
                throw new NoMeasurementException(writingColumnSchema.getMeasurementName());
            }
            IMeasurementSchema registeredColumnSchema = tableSchema.getColumnSchemas().get(columnIndex);
            if (!writingColumnSchema.getType().equals((Object)registeredColumnSchema.getType())) {
                throw new ConflictDataTypeException(writingColumnSchema.getType(), registeredColumnSchema.getType());
            }
            columnCategoryListForTablet.add(tableSchema.getColumnTypes().get(columnIndex));
        }
        tablet.setColumnCategories(columnCategoryListForTablet);
    }

    private void checkIsTimeseriesExist(Tablet tablet, boolean isAligned) throws WriteProcessException, IOException {
        IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(tablet.getDeviceId());
        IChunkGroupWriter groupWriter = this.tryToInitialGroupWriter(deviceID, isAligned, false);
        List<IMeasurementSchema> schemas = tablet.getSchemas();
        if (this.getSchema().containsDevice(deviceID)) {
            this.checkIsAllMeasurementsInGroup(this.getSchema().getSeriesSchema(deviceID), schemas, isAligned);
            if (isAligned) {
                for (IMeasurementSchema s : schemas) {
                    if (!this.flushedMeasurementsInDeviceMap.containsKey(deviceID) || this.flushedMeasurementsInDeviceMap.get(deviceID).contains(s.getMeasurementName())) continue;
                    throw new WriteProcessException("TsFile has flushed chunk group and should not add new measurement " + s.getMeasurementName() + " in device " + deviceID);
                }
            }
            groupWriter.tryToAddSeriesWriter(schemas);
        } else if (this.getSchema().getSchemaTemplates() != null && this.getSchema().getSchemaTemplates().size() == 1) {
            MeasurementGroup measurementGroup = this.getSchema().getSchemaTemplates().entrySet().iterator().next().getValue();
            this.checkIsAllMeasurementsInGroup(measurementGroup, schemas, isAligned);
            groupWriter.tryToAddSeriesWriter(schemas);
        } else {
            throw new NoDeviceException(deviceID.toString());
        }
    }

    private void checkIsAllMeasurementsInGroup(MeasurementGroup measurementGroup, List<IMeasurementSchema> measurementSchemas, boolean isAligned) throws NoMeasurementException {
        if (isAligned && !measurementGroup.isAligned()) {
            throw new NoMeasurementException("aligned");
        }
        if (!isAligned && measurementGroup.isAligned()) {
            throw new NoMeasurementException("nonAligned");
        }
        for (IMeasurementSchema measurementSchema : measurementSchemas) {
            if (measurementGroup.getMeasurementSchemaMap().containsKey(measurementSchema.getMeasurementName())) continue;
            if (isAligned) {
                throw new NoMeasurementException(measurementSchema.getMeasurementName());
            }
            measurementSchemas.remove(measurementSchema);
        }
    }

    private List<IMeasurementSchema> checkIsAllMeasurementsInGroup(List<DataPoint> dataPoints, MeasurementGroup measurementGroup, boolean isAligned) throws NoMeasurementException {
        if (isAligned && !measurementGroup.isAligned()) {
            throw new NoMeasurementException("aligned");
        }
        if (!isAligned && measurementGroup.isAligned()) {
            throw new NoMeasurementException("nonAligned");
        }
        ArrayList<IMeasurementSchema> schemas = new ArrayList<IMeasurementSchema>();
        for (DataPoint dataPoint : dataPoints) {
            if (!measurementGroup.getMeasurementSchemaMap().containsKey(dataPoint.getMeasurementId())) {
                if (isAligned) {
                    throw new NoMeasurementException(dataPoint.getMeasurementId());
                }
                LOG.warn("Ignore nonAligned measurement " + dataPoint.getMeasurementId() + " , because it is not registered or in the default template");
                continue;
            }
            schemas.add(measurementGroup.getMeasurementSchemaMap().get(dataPoint.getMeasurementId()));
        }
        return schemas;
    }

    private IChunkGroupWriter tryToInitialGroupWriter(IDeviceID deviceId, boolean isAligned, boolean isTableModel) throws IOException {
        IChunkGroupWriter groupWriter = this.groupWriters.get(deviceId);
        if (groupWriter == null) {
            if (isAligned) {
                groupWriter = isTableModel ? new TableChunkGroupWriterImpl(deviceId, this.encryptParam) : new AlignedChunkGroupWriterImpl(deviceId, this.encryptParam);
                this.initAllSeriesWriterForAlignedSeries((AlignedChunkGroupWriterImpl)groupWriter, deviceId, isTableModel);
                if (!this.isUnseq) {
                    ((AlignedChunkGroupWriterImpl)groupWriter).setLastTime(this.alignedDeviceLastTimeMap.get(deviceId));
                }
            } else {
                groupWriter = new NonAlignedChunkGroupWriterImpl(deviceId, this.encryptParam);
                if (!this.isUnseq) {
                    ((NonAlignedChunkGroupWriterImpl)groupWriter).setLastTimeMap(this.nonAlignedTimeseriesLastTimeMap.getOrDefault(deviceId, new HashMap()));
                }
            }
            this.groupWriters.put(deviceId, groupWriter);
        }
        return groupWriter;
    }

    private void initAllSeriesWriterForAlignedSeries(AlignedChunkGroupWriterImpl alignedChunkGroupWriter, IDeviceID deviceID, boolean isTableModel) throws IOException {
        Schema schema = this.getSchema();
        if (isTableModel) {
            alignedChunkGroupWriter.tryToAddSeriesWriter(schema.getTableSchemaMap().get(deviceID.getTableName()).getColumnSchemas());
        } else {
            MeasurementGroup deviceSchema = schema.getSeriesSchema(deviceID);
            for (IMeasurementSchema measurementSchema : deviceSchema.getMeasurementSchemaMap().values()) {
                alignedChunkGroupWriter.tryToAddSeriesWriterInternal(measurementSchema);
            }
        }
    }

    @TsFileApi
    public boolean writeRecord(TSRecord record) throws IOException, WriteProcessException {
        MeasurementGroup measurementGroup = this.getSchema().getSeriesSchema(record.deviceId);
        if (measurementGroup == null) {
            throw new NoDeviceException(record.deviceId.toString());
        }
        this.checkIsTimeseriesExist(record, measurementGroup.isAligned());
        this.recordCount += (long)this.groupWriters.get(record.deviceId).write(record.time, record.dataPointList);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    @TsFileApi
    public boolean writeTree(Tablet tablet) throws IOException, WriteProcessException {
        IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create(tablet.getDeviceId());
        MeasurementGroup measurementGroup = this.getSchema().getSeriesSchema(deviceID);
        if (measurementGroup == null) {
            throw new NoDeviceException(deviceID.toString());
        }
        this.checkIsTimeseriesExist(tablet, measurementGroup.isAligned());
        this.recordCount += (long)this.groupWriters.get(deviceID).write(tablet);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    @Deprecated
    public boolean writeAligned(Tablet tablet) throws IOException, WriteProcessException {
        this.checkIsTimeseriesExist(tablet, true);
        this.recordCount += (long)this.groupWriters.get(IDeviceID.Factory.DEFAULT_FACTORY.create(tablet.getDeviceId())).write(tablet);
        return this.checkMemorySizeAndMayFlushChunks();
    }

    private long calculateMemSizeForAllGroup() {
        long memTotalSize = 0L;
        for (IChunkGroupWriter group : this.groupWriters.values()) {
            memTotalSize += group.updateMaxGroupMemSize();
        }
        return memTotalSize;
    }

    private boolean checkMemorySizeAndMayFlushChunks() throws IOException {
        if (this.recordCount >= this.recordCountForNextMemCheck) {
            long memSize = this.calculateMemSizeForAllGroup();
            assert (memSize > 0L);
            if (memSize > this.chunkGroupSizeThreshold) {
                LOG.debug("start to flush chunk groups, memory space occupy:{}", (Object)memSize);
                this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
                return this.flush();
            }
            this.recordCountForNextMemCheck = this.recordCount * this.chunkGroupSizeThreshold / memSize;
            return false;
        }
        return false;
    }

    @TsFileApi
    public boolean flush() throws IOException {
        if (this.recordCount > 0L) {
            for (Map.Entry<IDeviceID, IChunkGroupWriter> entry : this.groupWriters.entrySet()) {
                IDeviceID deviceId = entry.getKey();
                IChunkGroupWriter groupWriter = entry.getValue();
                this.fileWriter.startChunkGroup(deviceId);
                long pos = this.fileWriter.getPos();
                long dataSize = groupWriter.flushToFileWriter(this.fileWriter);
                if (this.fileWriter.getPos() - pos != dataSize) {
                    throw new IOException(String.format("Flushed data size is inconsistent with computation! Estimated: %d, Actual: %d", dataSize, this.fileWriter.getPos() - pos));
                }
                this.fileWriter.endChunkGroup();
                if (groupWriter instanceof AlignedChunkGroupWriterImpl) {
                    List measurementList = this.flushedMeasurementsInDeviceMap.computeIfAbsent(deviceId, p -> new ArrayList());
                    ((AlignedChunkGroupWriterImpl)groupWriter).getMeasurements().forEach(measurementId -> {
                        if (!measurementList.contains(measurementId)) {
                            measurementList.add(measurementId);
                        }
                    });
                    if (this.isUnseq) continue;
                    this.alignedDeviceLastTimeMap.put(deviceId, ((AlignedChunkGroupWriterImpl)groupWriter).getLastTime());
                    continue;
                }
                if (this.isUnseq) continue;
                this.nonAlignedTimeseriesLastTimeMap.put(deviceId, ((NonAlignedChunkGroupWriterImpl)groupWriter).getLastTimeMap());
            }
            this.reset();
        }
        return false;
    }

    private void reset() {
        this.groupWriters.clear();
        this.recordCount = 0L;
    }

    @Override
    @TsFileApi
    public void close() throws IOException {
        LOG.info("start close file");
        this.flush();
        this.fileWriter.endFile();
    }

    public TsFileIOWriter getIOWriter() {
        return this.fileWriter;
    }

    public Schema getSchema() {
        return this.fileWriter.getSchema();
    }

    @TsFileApi
    public boolean writeTable(Tablet table) throws IOException, WriteProcessException {
        return this.writeTable(table, null);
    }

    public boolean writeTable(Tablet tablet, List<Pair<IDeviceID, Integer>> deviceIdEndIndexPairs) throws IOException, WriteProcessException {
        this.checkIsTableExistAndSetColumnCategoryList(tablet);
        if (deviceIdEndIndexPairs == null) {
            deviceIdEndIndexPairs = WriteUtils.splitTabletByDevice(tablet);
        }
        int startIndex = 0;
        for (Pair<IDeviceID, Integer> pair : deviceIdEndIndexPairs) {
            this.recordCount += (long)this.tryToInitialGroupWriter((IDeviceID)pair.left, this.isTableWriteAligned, true).write(tablet, startIndex, (Integer)pair.right);
            startIndex = (Integer)pair.right;
        }
        return this.checkMemorySizeAndMayFlushChunks();
    }

    public boolean isTableWriteAligned() {
        return this.isTableWriteAligned;
    }

    public void setTableWriteAligned(boolean tableWriteAligned) {
        this.isTableWriteAligned = tableWriteAligned;
    }

    public void registerTableSchema(TableSchema tableSchema) {
        this.getSchema().registerTableSchema(tableSchema);
    }

    public boolean isGenerateTableSchemaForTree() {
        return this.getIOWriter().isGenerateTableSchema();
    }

    public void setGenerateTableSchema(boolean generateTableSchema) {
        this.getIOWriter().setGenerateTableSchema(generateTableSchema);
    }
}

