/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.record;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.tsfile.annotations.TsFileApi;
import shaded.org.apache.tsfile.common.conf.TSFileConfig;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.StringContainer;
import shaded.org.apache.tsfile.write.record.datapoint.BooleanDataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.DataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.DateDataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.DoubleDataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.FloatDataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.IntDataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.LongDataPoint;
import shaded.org.apache.tsfile.write.record.datapoint.StringDataPoint;

public class TSRecord {
    public long time;
    public IDeviceID deviceId;
    public List<DataPoint> dataPointList = new ArrayList<DataPoint>();

    @TsFileApi
    public TSRecord(String deviceId, long timestamp) {
        this.time = timestamp;
        this.deviceId = IDeviceID.Factory.DEFAULT_FACTORY.create(deviceId);
    }

    @TsFileApi
    public TSRecord(IDeviceID deviceId, long timestamp) {
        this.time = timestamp;
        this.deviceId = deviceId;
    }

    public void setTime(long timestamp) {
        this.time = timestamp;
    }

    public TSRecord addTuple(DataPoint tuple) {
        this.dataPointList.add(tuple);
        return this;
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, int val) {
        return this.addTuple(new IntDataPoint(measurementName, val));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, long val) {
        return this.addTuple(new LongDataPoint(measurementName, val));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, float val) {
        return this.addTuple(new FloatDataPoint(measurementName, val));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, double val) {
        return this.addTuple(new DoubleDataPoint(measurementName, val));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, boolean val) {
        return this.addTuple(new BooleanDataPoint(measurementName, val));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, String val) {
        return this.addTuple(new StringDataPoint(measurementName, new Binary(val, TSFileConfig.STRING_CHARSET)));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, byte[] val) {
        return this.addTuple(new StringDataPoint(measurementName, new Binary(val)));
    }

    @TsFileApi
    public TSRecord addPoint(String measurementName, LocalDate val) {
        return this.addTuple(new DateDataPoint(measurementName, val));
    }

    public String toString() {
        StringContainer sc = new StringContainer(" ");
        sc.addTail("{device id:", this.deviceId, "time:", this.time, ",data:[");
        for (DataPoint tuple : this.dataPointList) {
            sc.addTail(tuple);
        }
        sc.addTail("]}");
        return sc.toString();
    }
}

