/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.record.datapoint;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.write.chunk.ChunkWriterImpl;
import shaded.org.apache.tsfile.write.record.datapoint.DataPoint;

public class LongDataPoint
extends DataPoint {
    private static final Logger LOG = LoggerFactory.getLogger(LongDataPoint.class);
    private long value;

    public LongDataPoint(String measurementId, long v) {
        super(TSDataType.INT64, measurementId);
        this.value = v;
    }

    @Override
    public void writeTo(long time, ChunkWriterImpl writer) {
        if (writer == null) {
            LOG.warn("given IChunkWriter is null, do nothing and return");
            return;
        }
        writer.write(time, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setLong(long value) {
        this.value = value;
    }
}

