/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.schema;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import shaded.org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.LogicalTableSchema;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.utils.MeasurementGroup;
import shaded.org.apache.tsfile.write.schema.IMeasurementSchema;
import shaded.org.apache.tsfile.write.schema.MeasurementSchema;

public class Schema
implements Serializable {
    private Map<IDeviceID, MeasurementGroup> registeredTimeseries;
    private Map<String, MeasurementGroup> schemaTemplates;
    private Map<String, TableSchema> tableSchemaMap = new HashMap<String, TableSchema>();
    private boolean enabledUpdateSchema = true;

    public Schema() {
        this.registeredTimeseries = new LinkedHashMap<IDeviceID, MeasurementGroup>();
    }

    public Schema(Map<IDeviceID, MeasurementGroup> knownSchema) {
        this.registeredTimeseries = knownSchema;
    }

    @Deprecated
    public void registerTimeseries(Path devicePath, IMeasurementSchema measurementSchema) {
        this.registerTimeseries(devicePath.getIDeviceID(), measurementSchema);
    }

    public void registerTimeseries(IDeviceID deviceID, IMeasurementSchema measurementSchema) {
        MeasurementGroup group = this.registeredTimeseries.getOrDefault(deviceID, new MeasurementGroup(false));
        group.getMeasurementSchemaMap().put(measurementSchema.getMeasurementName(), measurementSchema);
        this.registeredTimeseries.put(deviceID, group);
    }

    @Deprecated
    public void registerMeasurementGroup(Path devicePath, MeasurementGroup measurementGroup) {
        this.registeredTimeseries.put(devicePath.getIDeviceID(), measurementGroup);
    }

    public void registerMeasurementGroup(IDeviceID deviceID, MeasurementGroup measurementGroup) {
        this.registeredTimeseries.put(deviceID, measurementGroup);
    }

    public void registerSchemaTemplate(String templateName, MeasurementGroup measurementGroup) {
        if (this.schemaTemplates == null) {
            this.schemaTemplates = new HashMap<String, MeasurementGroup>();
        }
        this.schemaTemplates.put(templateName, measurementGroup);
    }

    public void registerTableSchema(TableSchema tableSchema) {
        this.tableSchemaMap.put(tableSchema.getTableName(), tableSchema);
    }

    public void extendTemplate(String templateName, MeasurementSchema descriptor) {
        if (this.schemaTemplates == null) {
            this.schemaTemplates = new HashMap<String, MeasurementGroup>();
        }
        MeasurementGroup measurementGroup = this.schemaTemplates.getOrDefault(templateName, new MeasurementGroup(false, new HashMap<String, IMeasurementSchema>()));
        measurementGroup.getMeasurementSchemaMap().put(descriptor.getMeasurementName(), descriptor);
        this.schemaTemplates.put(templateName, measurementGroup);
    }

    public void registerDevice(String deviceIdString, String templateName) {
        this.registerDevice(IDeviceID.Factory.DEFAULT_FACTORY.create(deviceIdString), templateName);
    }

    public void registerDevice(IDeviceID deviceId, String templateName) {
        if (!this.schemaTemplates.containsKey(templateName)) {
            return;
        }
        Map<String, IMeasurementSchema> template = this.schemaTemplates.get(templateName).getMeasurementSchemaMap();
        boolean isAligned = this.schemaTemplates.get(templateName).isAligned();
        this.registerMeasurementGroup(deviceId, new MeasurementGroup(isAligned, template));
    }

    @Deprecated
    public MeasurementGroup getSeriesSchema(Path devicePath) {
        return this.registeredTimeseries.get(devicePath.getIDeviceID());
    }

    public MeasurementGroup getSeriesSchema(IDeviceID devicePath) {
        return this.registeredTimeseries.get(devicePath);
    }

    public Map<String, MeasurementGroup> getSchemaTemplates() {
        return this.schemaTemplates;
    }

    public boolean containsDevice(IDeviceID devicePath) {
        return this.registeredTimeseries.containsKey(devicePath);
    }

    public void setRegisteredTimeseries(Map<IDeviceID, MeasurementGroup> registeredTimeseries) {
        this.registeredTimeseries = registeredTimeseries;
    }

    public Map<IDeviceID, MeasurementGroup> getRegisteredTimeseriesMap() {
        return this.registeredTimeseries;
    }

    public void updateTableSchema(ChunkGroupMetadata chunkGroupMetadata) {
        if (!this.enabledUpdateSchema) {
            return;
        }
        IDeviceID deviceID = chunkGroupMetadata.getDevice();
        String tableName = deviceID.getTableName();
        TableSchema tableSchema = this.tableSchemaMap.computeIfAbsent(tableName, LogicalTableSchema::new);
        tableSchema.update(chunkGroupMetadata);
    }

    public Map<String, TableSchema> getTableSchemaMap() {
        return this.tableSchemaMap;
    }

    public boolean isEnabledUpdateSchema() {
        return this.enabledUpdateSchema;
    }

    public void setEnabledUpdateSchema(boolean enabledUpdateSchema) {
        this.enabledUpdateSchema = enabledUpdateSchema;
    }
}

