/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.v4;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.tsfile.annotations.TsFileApi;
import shaded.org.apache.tsfile.enums.ColumnCategory;
import shaded.org.apache.tsfile.exception.write.ConflictDataTypeException;
import shaded.org.apache.tsfile.exception.write.NoMeasurementException;
import shaded.org.apache.tsfile.exception.write.NoTableException;
import shaded.org.apache.tsfile.exception.write.WriteProcessException;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.TableSchema;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.WriteUtils;
import shaded.org.apache.tsfile.write.chunk.AlignedChunkGroupWriterImpl;
import shaded.org.apache.tsfile.write.record.Tablet;
import shaded.org.apache.tsfile.write.schema.IMeasurementSchema;
import shaded.org.apache.tsfile.write.v4.AbstractTableModelTsFileWriter;

public class DeviceTableModelWriter
extends AbstractTableModelTsFileWriter {
    private String tableName;
    private TableSchema tableSchema;
    private boolean isTableWriteAligned = true;

    public DeviceTableModelWriter(File file, TableSchema tableSchema, long memoryThreshold) throws IOException {
        super(file, memoryThreshold);
        this.registerTableSchema(tableSchema);
    }

    @Override
    @TsFileApi
    public void write(Tablet table) throws IOException, WriteProcessException {
        this.checkIsTableExistAndSetColumnCategoryList(table);
        List<Pair<IDeviceID, Integer>> deviceIdEndIndexPairs = WriteUtils.splitTabletByDevice(table);
        int startIndex = 0;
        for (Pair<IDeviceID, Integer> pair : deviceIdEndIndexPairs) {
            this.recordCount += (long)this.tryToInitialGroupWriter((IDeviceID)pair.left, this.isTableWriteAligned, true).write(table, startIndex, (Integer)pair.right);
            startIndex = (Integer)pair.right;
        }
        this.checkMemorySizeAndMayFlushChunks();
    }

    @Override
    protected void initAllSeriesWriterForAlignedSeries(AlignedChunkGroupWriterImpl alignedChunkGroupWriter) throws IOException {
        alignedChunkGroupWriter.tryToAddSeriesWriter(this.tableSchema.getColumnSchemas());
    }

    private void checkIsTableExistAndSetColumnCategoryList(Tablet tablet) throws WriteProcessException {
        String tabletTableName = tablet.getTableName();
        if (tabletTableName != null && !this.tableName.equals(tabletTableName)) {
            throw new NoTableException(tabletTableName);
        }
        tablet.setTableName(this.tableName);
        TableSchema tableSchema = this.getSchema().getTableSchemaMap().get(this.tableName);
        ArrayList<ColumnCategory> columnCategoryListForTablet = new ArrayList<ColumnCategory>(tablet.getSchemas().size());
        for (IMeasurementSchema writingColumnSchema : tablet.getSchemas()) {
            int columnIndex = tableSchema.findColumnIndex(writingColumnSchema.getMeasurementName());
            if (columnIndex < 0) {
                throw new NoMeasurementException(writingColumnSchema.getMeasurementName());
            }
            IMeasurementSchema registeredColumnSchema = tableSchema.getColumnSchemas().get(columnIndex);
            if (!writingColumnSchema.getType().equals((Object)registeredColumnSchema.getType())) {
                throw new ConflictDataTypeException(writingColumnSchema.getType(), registeredColumnSchema.getType());
            }
            columnCategoryListForTablet.add(tableSchema.getColumnTypes().get(columnIndex));
        }
        tablet.setColumnCategories(columnCategoryListForTablet);
    }

    private void registerTableSchema(TableSchema tableSchema) {
        this.tableName = tableSchema.getTableName();
        this.tableSchema = tableSchema;
        this.getSchema().registerTableSchema(tableSchema);
    }
}

