/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.exception.write.TsFileNotCompleteException;
import shaded.org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import shaded.org.apache.tsfile.file.metadata.ChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.TsFileMetadata;
import shaded.org.apache.tsfile.fileSystem.FSFactoryProducer;
import shaded.org.apache.tsfile.read.TsFileSequenceReader;
import shaded.org.apache.tsfile.write.writer.TsFileIOWriter;

public class ForceAppendTsFileWriter
extends TsFileIOWriter {
    private long truncatePosition;
    private static Logger logger = LoggerFactory.getLogger(ForceAppendTsFileWriter.class);

    public ForceAppendTsFileWriter(File file) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{} writer is opened.", (Object)file.getName());
        }
        this.out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(file.getPath(), true);
        this.file = file;
        if (file.length() == 0L || !file.exists()) {
            throw new TsFileNotCompleteException("File " + file.getPath() + " is not a complete TsFile");
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader(file.getAbsolutePath(), true);){
            if (!reader.isComplete()) {
                throw new TsFileNotCompleteException("File " + file.getPath() + " is not a complete TsFile");
            }
            TsFileMetadata tsFileMetadata = reader.readFileMetadata();
            this.truncatePosition = tsFileMetadata.getMetaOffset();
            this.canWrite = true;
            List<IDeviceID> devices = reader.getAllDevices();
            for (IDeviceID device : devices) {
                ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
                reader.readChunkMetadataInDevice(device).values().forEach(chunkMetadataList::addAll);
                ChunkGroupMetadata chunkGroupMetadata = new ChunkGroupMetadata(device, chunkMetadataList);
                this.chunkGroupMetadataList.add(chunkGroupMetadata);
            }
        }
    }

    public void doTruncate() throws IOException {
        this.out.truncate(this.truncatePosition);
    }

    public long getTruncatePosition() {
        return this.truncatePosition;
    }
}

