/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.writer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import shaded.org.apache.tsfile.utils.NoSyncBufferedOutputStream;
import shaded.org.apache.tsfile.write.writer.TsFileOutput;

public class LocalTsFileOutput
extends OutputStream
implements TsFileOutput {
    private FileOutputStream outputStream;
    private OutputStream bufferedStream;
    private long position;

    public LocalTsFileOutput(FileOutputStream outputStream) {
        this.outputStream = outputStream;
        this.bufferedStream = new NoSyncBufferedOutputStream(outputStream);
        this.position = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        this.bufferedStream.write(b);
        ++this.position;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.bufferedStream.write(b);
        this.position += (long)b.length;
    }

    @Override
    public void write(byte b) throws IOException {
        this.bufferedStream.write(b);
        ++this.position;
    }

    @Override
    public void write(byte[] buf, int start, int offset) throws IOException {
        this.bufferedStream.write(buf, start, offset);
        this.position += (long)offset;
    }

    @Override
    public void write(ByteBuffer b) throws IOException {
        this.bufferedStream.write(b.array());
        this.position += (long)b.array().length;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void close() throws IOException {
        this.bufferedStream.close();
        this.outputStream.close();
    }

    @Override
    public OutputStream wrapAsStream() {
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.bufferedStream.flush();
    }

    @Override
    public void truncate(long size) throws IOException {
        this.bufferedStream.flush();
        this.outputStream.getChannel().truncate(size);
        this.position = this.outputStream.getChannel().position();
    }

    @Override
    public void force() throws IOException {
        this.flush();
        this.outputStream.getFD().sync();
    }
}

