/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.writer.tsmiterator;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import shaded.org.apache.tsfile.file.metadata.ChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.TimeseriesMetadata;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.read.reader.LocalTsFileInput;
import shaded.org.apache.tsfile.read.reader.TsFileInput;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;
import shaded.org.apache.tsfile.write.writer.tsmiterator.TSMIterator;

public class DiskTSMIterator
extends TSMIterator {
    private static final Logger LOG = LoggerFactory.getLogger(DiskTSMIterator.class);
    private LinkedList<Long> endPosForEachDevice;
    protected TsFileInput input;
    private long fileLength = 0L;
    private long currentPos = 0L;
    private long nextEndPosForDevice = 0L;
    private IDeviceID currentDevice;
    private boolean remainsInFile = true;

    protected DiskTSMIterator(File cmtFile, List<ChunkGroupMetadata> chunkGroupMetadataList, LinkedList<Long> endPosForEachDevice) throws IOException {
        super(chunkGroupMetadataList);
        this.endPosForEachDevice = endPosForEachDevice;
        this.input = new LocalTsFileInput(cmtFile.toPath());
        this.fileLength = cmtFile.length();
        this.nextEndPosForDevice = endPosForEachDevice.removeFirst();
    }

    @Override
    public boolean hasNext() {
        return this.remainsInFile || this.iterator.hasNext();
    }

    @Override
    public Pair<Path, TimeseriesMetadata> next() throws IOException {
        try {
            if (this.remainsInFile) {
                return this.getTimeSeriesMetadataFromFile();
            }
            return super.next();
        }
        catch (IOException e) {
            if (!Thread.currentThread().isInterrupted()) {
                LOG.error("Meets IOException when reading timeseries metadata from disk", e);
            }
            throw e;
        }
    }

    private Pair<Path, TimeseriesMetadata> getTimeSeriesMetadataFromFile() throws IOException {
        if (this.currentPos == this.nextEndPosForDevice) {
            this.currentDevice = IDeviceID.Deserializer.DEFAULT_DESERIALIZER.deserializeFrom(this.input.wrapAsInputStream());
            this.nextEndPosForDevice = this.endPosForEachDevice.size() > 0 ? this.endPosForEachDevice.removeFirst() : this.fileLength;
        }
        String measurementUid = ReadWriteIOUtils.readVarIntString(this.input.wrapAsInputStream());
        byte dataTypeInByte = ReadWriteIOUtils.readByte(this.input.wrapAsInputStream());
        TSDataType dataType = TSDataType.getTsDataType(dataTypeInByte);
        int chunkBufferSize = ReadWriteIOUtils.readInt(this.input.wrapAsInputStream());
        ByteBuffer chunkBuffer = ByteBuffer.allocate(chunkBufferSize);
        int readSize = ReadWriteIOUtils.readAsPossible(this.input, chunkBuffer);
        if (readSize < chunkBufferSize) {
            throw new IOException(String.format("Expected to read %s bytes, but actually read %s bytes", chunkBufferSize, readSize));
        }
        chunkBuffer.flip();
        ArrayList<IChunkMetadata> chunkMetadataList = new ArrayList<IChunkMetadata>();
        while (chunkBuffer.hasRemaining()) {
            chunkMetadataList.add(ChunkMetadata.deserializeFrom(chunkBuffer, dataType));
        }
        this.updateCurrentPos();
        return new Pair<Path, TimeseriesMetadata>(new Path(this.currentDevice, measurementUid, false), DiskTSMIterator.constructOneTimeseriesMetadata(measurementUid, chunkMetadataList));
    }

    private void updateCurrentPos() throws IOException {
        this.currentPos = this.input.position();
        if (this.currentPos >= this.fileLength) {
            this.remainsInFile = false;
            this.input.close();
        }
    }
}

