/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.tsfile.write.writer.tsmiterator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.ChunkGroupMetadata;
import shaded.org.apache.tsfile.file.metadata.ChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IChunkMetadata;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.TimeseriesMetadata;
import shaded.org.apache.tsfile.file.metadata.enums.CompressionType;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.file.metadata.statistics.Statistics;
import shaded.org.apache.tsfile.read.common.FullPath;
import shaded.org.apache.tsfile.read.common.Path;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.PublicBAOS;
import shaded.org.apache.tsfile.write.writer.tsmiterator.DiskTSMIterator;

public class TSMIterator {
    private static final Logger LOG = LoggerFactory.getLogger(TSMIterator.class);
    protected Iterable<Pair<Path, List<IChunkMetadata>>> sortedChunkMetadataList;
    protected Iterator<Pair<Path, List<IChunkMetadata>>> iterator;
    private static final Comparator<Path> deviceMapComparator = Comparator.comparing(Path::getMeasurement);

    protected TSMIterator(List<ChunkGroupMetadata> chunkGroupMetadataList) {
        this.sortedChunkMetadataList = TSMIterator.sortChunkMetadata(chunkGroupMetadataList, null, null);
        this.iterator = this.sortedChunkMetadataList.iterator();
    }

    public static TSMIterator getTSMIteratorInMemory(List<ChunkGroupMetadata> chunkGroupMetadataList) {
        return new TSMIterator(chunkGroupMetadataList);
    }

    public static TSMIterator getTSMIteratorInDisk(File cmtFile, List<ChunkGroupMetadata> chunkGroupMetadataList, LinkedList<Long> serializePos) throws IOException {
        return new DiskTSMIterator(cmtFile, chunkGroupMetadataList, serializePos);
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Pair<Path, TimeseriesMetadata> next() throws IOException {
        Pair<Path, List<IChunkMetadata>> nextPair = this.iterator.next();
        return new Pair<Path, TimeseriesMetadata>((Path)nextPair.left, TSMIterator.constructOneTimeseriesMetadata(((Path)nextPair.left).getMeasurement(), (List)nextPair.right));
    }

    public static TimeseriesMetadata constructOneTimeseriesMetadata(String measurementId, List<IChunkMetadata> chunkMetadataList) throws IOException {
        PublicBAOS publicBAOS = new PublicBAOS();
        TSDataType dataType = chunkMetadataList.get(chunkMetadataList.size() - 1).getDataType();
        Statistics<Serializable> seriesStatistics = Statistics.getStatsByType(dataType);
        int chunkMetadataListLength = 0;
        boolean serializeStatistic = chunkMetadataList.size() > 1;
        for (IChunkMetadata chunkMetadata : chunkMetadataList) {
            if (!chunkMetadata.getDataType().equals((Object)dataType)) continue;
            chunkMetadataListLength += chunkMetadata.serializeTo(publicBAOS, serializeStatistic);
            seriesStatistics.mergeStatistics(chunkMetadata.getStatistics());
        }
        TimeseriesMetadata timeseriesMetadata = new TimeseriesMetadata((byte)((serializeStatistic ? (byte)1 : 0) | chunkMetadataList.get(0).getMask()), chunkMetadataListLength, measurementId, dataType, seriesStatistics, publicBAOS);
        return timeseriesMetadata;
    }

    public static Iterable<Pair<Path, List<IChunkMetadata>>> sortChunkMetadata(List<ChunkGroupMetadata> chunkGroupMetadataList, IDeviceID currentDevice, List<ChunkMetadata> chunkMetadataList) {
        TreeMap<IDeviceID, SortedMap> chunkMetadataMap = new TreeMap<IDeviceID, SortedMap>();
        for (ChunkGroupMetadata chunkGroupMetadata : chunkGroupMetadataList) {
            SortedMap sortedMap = chunkMetadataMap.computeIfAbsent(chunkGroupMetadata.getDevice(), x -> new TreeMap(deviceMapComparator));
            for (IChunkMetadata iChunkMetadata : chunkGroupMetadata.getChunkMetadataList()) {
                sortedMap.computeIfAbsent(new FullPath(chunkGroupMetadata.getDevice(), iChunkMetadata.getMeasurementUid()), x -> new ArrayList(1)).add(iChunkMetadata);
            }
        }
        if (currentDevice != null) {
            SortedMap deviceMap = chunkMetadataMap.computeIfAbsent(currentDevice, x -> new TreeMap());
            for (IChunkMetadata iChunkMetadata : chunkMetadataList) {
                deviceMap.computeIfAbsent(new FullPath(currentDevice, iChunkMetadata.getMeasurementUid()), x -> new ArrayList(1)).add(iChunkMetadata);
            }
        }
        return () -> chunkMetadataMap.values().stream().flatMap(deviceMap -> deviceMap.entrySet().stream()).map(e -> new Pair<Path, List>((Path)e.getKey(), (List)e.getValue())).iterator();
    }

    private static void testSortChunkMetadata() {
        int deviceNum = 100;
        int measurementNum = 10000;
        ArrayList<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
        for (int i = 0; i < deviceNum; ++i) {
            ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
            for (int j = 0; j < measurementNum; ++j) {
                chunkMetadataList.add(new ChunkMetadata("s" + j, TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, 0L, null));
            }
            IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create("root.db1.d" + i);
            chunkGroupMetadataList.add(new ChunkGroupMetadata(deviceID, chunkMetadataList));
        }
        int repeat = 100;
        long start = System.currentTimeMillis();
        for (int i = 0; i < repeat; ++i) {
            long sortStart = System.nanoTime();
            Iterable<Pair<Path, List<IChunkMetadata>>> pairs = TSMIterator.sortChunkMetadata(chunkGroupMetadataList, null, null);
            long sortEnd = System.nanoTime();
            for (Pair<Path, List<IChunkMetadata>> pair : pairs) {
            }
            long iterationEnd = System.nanoTime();
            System.out.println("Sort " + (sortEnd - sortStart) + ", iteration" + (iterationEnd - sortEnd));
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    public static void main(String[] args) throws IOException {
        int deviceNum = 100;
        int measurementNum = 10000;
        ArrayList<ChunkGroupMetadata> chunkGroupMetadataList = new ArrayList<ChunkGroupMetadata>();
        for (int i = 0; i < deviceNum; ++i) {
            ArrayList<ChunkMetadata> chunkMetadataList = new ArrayList<ChunkMetadata>();
            for (int j = 0; j < measurementNum; ++j) {
                chunkMetadataList.add(new ChunkMetadata("s" + j, TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, 0L, Statistics.getStatsByType(TSDataType.INT64)));
            }
            IDeviceID deviceID = IDeviceID.Factory.DEFAULT_FACTORY.create("root.db1.d" + i);
            chunkGroupMetadataList.add(new ChunkGroupMetadata(deviceID, chunkMetadataList));
        }
        int repeat = 100;
        long start = System.currentTimeMillis();
        for (int i = 0; i < repeat; ++i) {
            TSMIterator tsmIterator = new TSMIterator(chunkGroupMetadataList);
            while (tsmIterator.hasNext()) {
                tsmIterator.next();
            }
        }
        System.out.println(System.currentTimeMillis() - start);
    }
}

