/*
 * Decompiled with CFR 0.152.
 */
package com.timgroup.jgravatar;

import com.timgroup.jgravatar.GravatarDefaultImage;
import com.timgroup.jgravatar.GravatarDownloadException;
import com.timgroup.jgravatar.GravatarRating;
import com.timgroup.jgravatar.internal.com.google.common.base.Joiner;
import com.timgroup.jgravatar.internal.com.google.common.base.Preconditions;
import com.timgroup.jgravatar.internal.com.google.common.hash.Hashing;
import com.timgroup.jgravatar.internal.com.google.common.io.ByteStreams;
import com.timgroup.jgravatar.internal.com.google.common.io.Closeables;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Gravatar {
    private static final String GRAVATAR_URL = "http://www.gravatar.com/avatar/";
    public static final int DEFAULT_SIZE = 80;
    public static final GravatarRating DEFAULT_RATING = GravatarRating.GENERAL_AUDIENCES;
    public static final GravatarDefaultImage DEFAULT_DEFAULT_IMAGE = GravatarDefaultImage.HTTP_404;
    private final int size;
    private final GravatarRating rating;
    private final GravatarDefaultImage defaultImage;

    public Gravatar(int size, GravatarRating rating, GravatarDefaultImage defaultImage) {
        this.size = size;
        this.rating = rating;
        this.defaultImage = defaultImage;
    }

    public Gravatar() {
        this(80, DEFAULT_RATING, DEFAULT_DEFAULT_IMAGE);
    }

    public Gravatar setSize(int sizeInPixels) {
        Preconditions.checkArgument(sizeInPixels >= 1 && sizeInPixels <= 512, "sizeInPixels needs to be between 1 and 512");
        return new Gravatar(sizeInPixels, this.rating, this.defaultImage);
    }

    public Gravatar setRating(GravatarRating rating) {
        Preconditions.checkNotNull(rating, "rating");
        return new Gravatar(this.size, rating, this.defaultImage);
    }

    public Gravatar setDefaultImage(GravatarDefaultImage defaultImage) {
        Preconditions.checkNotNull(defaultImage, "defaultImage");
        return new Gravatar(this.size, this.rating, defaultImage);
    }

    public String getUrl(String email) {
        Preconditions.checkNotNull(email, "email");
        String emailHash = Hashing.md5().hashString(email.toLowerCase().trim(), Charset.forName("UTF-8")).toString();
        String params = this.formatUrlParameters();
        return GRAVATAR_URL + emailHash + ".jpg" + params;
    }

    /*
     * Loose catch block
     */
    public byte[] download(String email) throws GravatarDownloadException {
        InputStream stream = null;
        try {
            URL url = new URL(this.getUrl(email));
            stream = url.openStream();
            byte[] byArray = ByteStreams.toByteArray(stream);
            Closeables.closeQuietly(stream);
            return byArray;
        }
        catch (FileNotFoundException e) {
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception e2) {
            throw new GravatarDownloadException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Closeables.closeQuietly(stream);
        }
    }

    private String formatUrlParameters() {
        ArrayList<String> params = new ArrayList<String>();
        if (this.size != 80) {
            params.add("s=" + this.size);
        }
        if (this.rating != DEFAULT_RATING) {
            params.add("r=" + this.rating.getCode());
        }
        if (this.defaultImage != GravatarDefaultImage.GRAVATAR_ICON) {
            params.add("d=" + this.defaultImage.getCode());
        }
        if (params.isEmpty()) {
            return "";
        }
        return "?" + Joiner.on("&").join(params.iterator());
    }
}

