/*
 * Decompiled with CFR 0.152.
 */
package com.timushev.sbt.updates.metadata;

import com.timushev.sbt.updates.Downloader;
import com.timushev.sbt.updates.authentication.RepositoryAuthentication;
import com.timushev.sbt.updates.metadata.CachingMetadataLoader;
import com.timushev.sbt.updates.metadata.CompoundMetadataLoader;
import com.timushev.sbt.updates.metadata.IvyMetadataLoader;
import com.timushev.sbt.updates.metadata.MavenMetadataLoader;
import com.timushev.sbt.updates.metadata.MetadataLoader;
import com.timushev.sbt.updates.versions.Version;
import java.io.Serializable;
import java.net.URL;
import sbt.librarymanagement.MavenRepository;
import sbt.librarymanagement.ModuleID;
import sbt.librarymanagement.Resolver;
import sbt.librarymanagement.URLRepository;
import sbt.package$;
import sbt.util.Logger;
import scala.Function$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class MetadataLoaderFactory$ {
    public static MetadataLoaderFactory$ MODULE$;
    private final Regex KnownProtocol;
    private final Regex KnownProtocolUrl;
    private final Map<Resolver, Option<MetadataLoader>> loaderCache;
    private final Map<Tuple2<MetadataLoader, ModuleID>, Future<Seq<Version>>> cache;

    static {
        new MetadataLoaderFactory$();
    }

    public Regex KnownProtocol() {
        return this.KnownProtocol;
    }

    public Regex KnownProtocolUrl() {
        return this.KnownProtocolUrl;
    }

    public PartialFunction<Resolver, MetadataLoader> loader(Logger logger, Seq<RepositoryAuthentication> authentications) {
        return Function$.MODULE$.unlift((Function1 & Serializable & scala.Serializable)resolver -> {
            Option option;
            Map<Resolver, Option<MetadataLoader>> map = MODULE$.loaderCache();
            synchronized (map) {
                option = (Option)MODULE$.loaderCache().getOrElseUpdate(resolver, (Function0 & Serializable & scala.Serializable)() -> MODULE$.newLoader(logger, authentications, (Resolver)resolver).map((Function1 & Serializable & scala.Serializable)loader -> MODULE$.cached((MetadataLoader)loader)));
            }
            return option;
        });
    }

    private Option<MetadataLoader> newLoader(Logger logger, Seq<RepositoryAuthentication> authentications, Resolver resolver) {
        None$ none$;
        Resolver resolver2 = resolver;
        if (resolver2 instanceof MavenRepository) {
            None$ none$2;
            MavenRepository mavenRepository = (MavenRepository)resolver2;
            Downloader downloader = new Downloader(mavenRepository.name(), authentications, logger);
            URL url = new URL(mavenRepository.root());
            String string = url.getProtocol();
            Option option = this.KnownProtocol().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
                URLRepository resolver3 = package$.MODULE$.Resolver().url().apply(mavenRepository.name(), url, package$.MODULE$.Resolver().mavenStylePatterns());
                MavenMetadataLoader mavenLoader = new MavenMetadataLoader(resolver3, downloader);
                IvyMetadataLoader ivyLoader = new IvyMetadataLoader(resolver3, downloader);
                none$2 = new Some((Object)new CompoundMetadataLoader((Seq<MetadataLoader>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataLoader[]{mavenLoader, ivyLoader})))));
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else if (resolver2 instanceof URLRepository) {
            None$ none$3;
            URLRepository uRLRepository = (URLRepository)resolver2;
            if (uRLRepository.patterns().artifactPatterns().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataLoaderFactory$.$anonfun$newLoader$1(x$1)))) {
                Downloader downloader = new Downloader(uRLRepository.name(), authentications, logger);
                none$3 = new Some((Object)new IvyMetadataLoader(uRLRepository, downloader));
            } else {
                none$3 = None$.MODULE$;
            }
            none$ = none$3;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Map<Resolver, Option<MetadataLoader>> loaderCache() {
        return this.loaderCache;
    }

    private Map<Tuple2<MetadataLoader, ModuleID>, Future<Seq<Version>>> cache() {
        return this.cache;
    }

    private CachingMetadataLoader cached(MetadataLoader loader) {
        return new CachingMetadataLoader(loader, this.cache());
    }

    public static final /* synthetic */ boolean $anonfun$newLoader$1(String x$1) {
        return MODULE$.KnownProtocolUrl().findFirstIn((CharSequence)x$1).nonEmpty();
    }

    private MetadataLoaderFactory$() {
        MODULE$ = this;
        this.KnownProtocol = new StringOps(Predef$.MODULE$.augmentString("(?i)^https?$")).r();
        this.KnownProtocolUrl = new StringOps(Predef$.MODULE$.augmentString("(?i)^https?://")).r();
        this.loaderCache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.cache = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

