/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Element;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import org.neo4j.graphdb.Relationship;

public class Neo4j2Edge
extends Neo4j2Element
implements Edge {
    public Neo4j2Edge(Relationship relationship, Neo4j2Graph graph) {
        super(graph);
        this.rawElement = relationship;
    }

    public String getLabel() {
        this.graph.autoStartTransaction(false);
        return ((Relationship)this.rawElement).getType().name();
    }

    public Vertex getVertex(Direction direction) {
        this.graph.autoStartTransaction(false);
        if (direction.equals((Object)Direction.OUT)) {
            return new Neo4j2Vertex(((Relationship)this.rawElement).getStartNode(), this.graph);
        }
        if (direction.equals((Object)Direction.IN)) {
            return new Neo4j2Vertex(((Relationship)this.rawElement).getEndNode(), this.graph);
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Neo4j2Edge && ((Neo4j2Edge)object).getId().equals(this.getId());
    }

    public String toString() {
        return StringFactory.edgeString((Edge)this);
    }

    public Relationship getRawEdge() {
        return (Relationship)this.rawElement;
    }
}

