/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Edge;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import java.util.Iterator;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;

public class Neo4j2EdgeIterable<T extends Edge>
implements CloseableIterable<Neo4j2Edge> {
    private final Iterable<Relationship> relationships;
    private final Neo4j2Graph graph;
    private final boolean checkTransaction;

    public Neo4j2EdgeIterable(Iterable<Relationship> relationships, Neo4j2Graph graph, boolean checkTransaction) {
        this.relationships = relationships;
        this.graph = graph;
        this.checkTransaction = checkTransaction;
    }

    public Neo4j2EdgeIterable(Iterable<Relationship> relationships, Neo4j2Graph graph) {
        this(relationships, graph, false);
    }

    public Iterator<Neo4j2Edge> iterator() {
        return new Iterator<Neo4j2Edge>(){
            private final Iterator<Relationship> itty;
            private Relationship nextRelationship;
            {
                this.itty = Neo4j2EdgeIterable.this.relationships.iterator();
                this.nextRelationship = null;
            }

            @Override
            public void remove() {
                Neo4j2EdgeIterable.this.graph.autoStartTransaction(true);
                this.itty.remove();
            }

            @Override
            public Neo4j2Edge next() {
                Neo4j2EdgeIterable.this.graph.autoStartTransaction(false);
                if (!Neo4j2EdgeIterable.this.checkTransaction) {
                    return new Neo4j2Edge(this.itty.next(), Neo4j2EdgeIterable.this.graph);
                }
                if (null != this.nextRelationship) {
                    Relationship temp = this.nextRelationship;
                    this.nextRelationship = null;
                    return new Neo4j2Edge(temp, Neo4j2EdgeIterable.this.graph);
                }
                while (true) {
                    Relationship relationship = this.itty.next();
                    try {
                        if (Neo4j2EdgeIterable.this.graph.relationshipIsDeleted(relationship.getId())) continue;
                        return new Neo4j2Edge(relationship, Neo4j2EdgeIterable.this.graph);
                    }
                    catch (IllegalStateException illegalStateException) {
                        continue;
                    }
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                Neo4j2EdgeIterable.this.graph.autoStartTransaction(false);
                if (!Neo4j2EdgeIterable.this.checkTransaction) {
                    return this.itty.hasNext();
                }
                if (null != this.nextRelationship) {
                    return true;
                }
                while (this.itty.hasNext()) {
                    Relationship relationship = this.itty.next();
                    try {
                        if (Neo4j2EdgeIterable.this.graph.relationshipIsDeleted(relationship.getId())) continue;
                        this.nextRelationship = relationship;
                        return true;
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                return false;
            }
        };
    }

    public void close() {
        if (this.relationships instanceof IndexHits) {
            ((IndexHits)this.relationships).close();
        }
    }
}

