/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

abstract class Neo4j2Element
implements Element {
    protected final Neo4j2Graph graph;
    protected PropertyContainer rawElement;

    public Neo4j2Element(Neo4j2Graph graph) {
        this.graph = graph;
    }

    public <T> T getProperty(String key) {
        this.graph.autoStartTransaction(false);
        if (this.rawElement.hasProperty(key)) {
            return (T)this.tryConvertCollectionToArrayList(this.rawElement.getProperty(key));
        }
        return null;
    }

    public void setProperty(String key, Object value) {
        ElementHelper.validateProperty((Element)this, (String)key, (Object)value);
        this.graph.autoStartTransaction(true);
        this.rawElement.setProperty(key, this.tryConvertCollectionToArray(value));
    }

    public <T> T removeProperty(String key) {
        if (!this.rawElement.hasProperty(key)) {
            return null;
        }
        this.graph.autoStartTransaction(true);
        return (T)this.rawElement.removeProperty(key);
    }

    public Set<String> getPropertyKeys() {
        this.graph.autoStartTransaction(false);
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.rawElement.getPropertyKeys()) {
            keys.add(key);
        }
        return keys;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public PropertyContainer getRawElement() {
        return this.rawElement;
    }

    public Object getId() {
        this.graph.autoStartTransaction(false);
        if (this.rawElement instanceof Node) {
            return ((Node)this.rawElement).getId();
        }
        return ((Relationship)this.rawElement).getId();
    }

    public void remove() {
        if (this instanceof Vertex) {
            this.graph.removeVertex((Vertex)this);
        } else {
            this.graph.removeEdge((Edge)this);
        }
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    private Object tryConvertCollectionToArray(Object value) {
        if (value instanceof Collection) {
            try {
                Collection collection = (Collection)value;
                Object[] array = null;
                Iterator objects = collection.iterator();
                int i = 0;
                while (objects.hasNext()) {
                    Object object = objects.next();
                    if (array == null) {
                        array = (Object[])Array.newInstance(object.getClass(), collection.size());
                    }
                    array[i] = object;
                    ++i;
                }
                return array;
            }
            catch (ArrayStoreException ase) {
                return value;
            }
        }
        return value;
    }

    private Object tryConvertCollectionToArrayList(Object value) {
        if (value.getClass().isArray()) {
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                int arrlength = Array.getLength(value);
                for (int i = 0; i < arrlength; ++i) {
                    Object object = Array.get(value, i);
                    list.add(object);
                }
                return list;
            }
            catch (Exception e) {
                return value;
            }
        }
        return value;
    }
}

