/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.IndexableGraph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.MetaGraph;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Edge;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2EdgeIterable;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Index;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2VertexIterable;
import com.tinkerpop.blueprints.util.DefaultGraphQuery;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.KeyIndexableGraphHelper;
import com.tinkerpop.blueprints.util.PropertyFilteredIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.transaction.AbstractTransactionManager;
import org.neo4j.tooling.GlobalGraphOperations;

public class Neo4j2Graph
implements TransactionalGraph,
IndexableGraph,
KeyIndexableGraph,
MetaGraph<GraphDatabaseService> {
    private static final Logger logger = Logger.getLogger(Neo4j2Graph.class.getName());
    private GraphDatabaseService rawGraph;
    private static final String INDEXED_KEYS_POSTFIX = ":indexed_keys";
    protected final ThreadLocal<org.neo4j.graphdb.Transaction> tx = new ThreadLocal<org.neo4j.graphdb.Transaction>(){

        @Override
        protected org.neo4j.graphdb.Transaction initialValue() {
            return null;
        }
    };
    protected final ThreadLocal<Boolean> checkElementsInTransaction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final Features FEATURES = new Features();
    private final TransactionManager transactionManager;
    private final ExecutionEngine cypher;

    protected boolean checkElementsInTransaction() {
        if (this.tx.get() == null) {
            return false;
        }
        return this.checkElementsInTransaction.get();
    }

    public void setCheckElementsInTransaction(boolean checkElementsInTransaction) {
        this.checkElementsInTransaction.set(checkElementsInTransaction);
    }

    public Neo4j2Graph(String directory) {
        this(directory, null);
    }

    public Neo4j2Graph(GraphDatabaseService rawGraph) {
        this.rawGraph = rawGraph;
        this.transactionManager = (TransactionManager)((GraphDatabaseAPI)rawGraph).getDependencyResolver().resolveDependency(TransactionManager.class);
        this.cypher = new ExecutionEngine(rawGraph);
        this.init();
    }

    public Neo4j2Graph(String directory, Map<String, String> configuration) {
        try {
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(directory);
            this.rawGraph = null != configuration ? builder.setConfig(configuration).newGraphDatabase() : builder.newGraphDatabase();
            this.transactionManager = (TransactionManager)((GraphDatabaseAPI)this.rawGraph).getDependencyResolver().resolveDependency(TransactionManager.class);
            this.cypher = new ExecutionEngine(this.rawGraph);
            this.init();
        }
        catch (Exception e) {
            if (this.rawGraph != null) {
                this.rawGraph.shutdown();
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void init() {
        this.loadKeyIndices();
    }

    public Neo4j2Graph(Configuration configuration) {
        this(configuration.getString("blueprints.neo4j.directory", null), ConfigurationConverter.getMap((Configuration)configuration.subset("blueprints.neo4j.conf")));
    }

    private void loadKeyIndices() {
        this.autoStartTransaction(true);
        for (String key : this.getInternalIndexKeys(Vertex.class)) {
            this.createKeyIndex(key, Vertex.class, new Parameter[0]);
        }
        for (String key : this.getInternalIndexKeys(Edge.class)) {
            this.createKeyIndex(key, Edge.class, new Parameter[0]);
        }
        this.commit();
    }

    private <T extends Element> void createInternalIndexKey(String key, Class<T> elementClass) {
        String propertyName = elementClass.getSimpleName() + INDEXED_KEYS_POSTFIX;
        if (this.rawGraph instanceof GraphDatabaseAPI) {
            PropertyContainer pc = this.getGraphProperties();
            try {
                String[] keys = (String[])pc.getProperty(propertyName);
                HashSet<String> temp = new HashSet<String>(Arrays.asList(keys));
                temp.add(key);
                pc.setProperty(propertyName, (Object)temp.toArray(new String[temp.size()]));
            }
            catch (Exception e) {
                pc.setProperty(propertyName, (Object)new String[]{key});
            }
        } else {
            throw new UnsupportedOperationException("Unable to create an index on a non-GraphDatabaseAPI graph");
        }
    }

    private <T extends Element> void dropInternalIndexKey(String key, Class<T> elementClass) {
        String propertyName = elementClass.getSimpleName() + INDEXED_KEYS_POSTFIX;
        if (this.rawGraph instanceof GraphDatabaseAPI) {
            PropertyContainer pc = this.getGraphProperties();
            try {
                String[] keys = (String[])pc.getProperty(propertyName);
                HashSet<String> temp = new HashSet<String>(Arrays.asList(keys));
                temp.remove(key);
                pc.setProperty(propertyName, (Object)temp.toArray(new String[temp.size()]));
            }
            catch (Exception e) {}
        } else {
            this.logNotGraphDatabaseAPI();
        }
    }

    public <T extends Element> Set<String> getInternalIndexKeys(Class<T> elementClass) {
        String propertyName = elementClass.getSimpleName() + INDEXED_KEYS_POSTFIX;
        if (this.rawGraph instanceof GraphDatabaseAPI) {
            PropertyContainer pc = this.getGraphProperties();
            try {
                String[] keys = (String[])pc.getProperty(propertyName);
                return new HashSet<String>(Arrays.asList(keys));
            }
            catch (Exception e) {}
        } else {
            this.logNotGraphDatabaseAPI();
        }
        return Collections.emptySet();
    }

    private PropertyContainer getGraphProperties() {
        return ((NodeManager)((GraphDatabaseAPI)this.rawGraph).getDependencyResolver().resolveDependency(NodeManager.class)).getGraphProperties();
    }

    private void logNotGraphDatabaseAPI() {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Indices are not available on non-GraphDatabaseAPI instances Current graph class is " + this.rawGraph.getClass().getName());
        }
    }

    public synchronized <T extends Element> Index<T> createIndex(String indexName, Class<T> indexClass, Parameter ... indexParameters) {
        this.autoStartTransaction(true);
        if (this.rawGraph.index().existsForNodes(indexName) || this.rawGraph.index().existsForRelationships(indexName)) {
            throw ExceptionFactory.indexAlreadyExists((String)indexName);
        }
        return new Neo4j2Index(indexName, indexClass, this, indexParameters);
    }

    public <T extends Element> Index<T> getIndex(String indexName, Class<T> indexClass) {
        this.autoStartTransaction(false);
        if (Vertex.class.isAssignableFrom(indexClass)) {
            if (this.rawGraph.index().existsForNodes(indexName)) {
                return new Neo4j2Index(indexName, indexClass, this, new Parameter[0]);
            }
            if (this.rawGraph.index().existsForRelationships(indexName)) {
                throw ExceptionFactory.indexDoesNotSupportClass((String)indexName, indexClass);
            }
            return null;
        }
        if (Edge.class.isAssignableFrom(indexClass)) {
            if (this.rawGraph.index().existsForRelationships(indexName)) {
                return new Neo4j2Index(indexName, indexClass, this, new Parameter[0]);
            }
            if (this.rawGraph.index().existsForNodes(indexName)) {
                throw ExceptionFactory.indexDoesNotSupportClass((String)indexName, indexClass);
            }
            return null;
        }
        return null;
    }

    public synchronized void dropIndex(String indexName) {
        RelationshipIndex relationshipIndex;
        this.autoStartTransaction(true);
        if (this.rawGraph.index().existsForNodes(indexName)) {
            org.neo4j.graphdb.index.Index nodeIndex = this.rawGraph.index().forNodes(indexName);
            if (nodeIndex.isWriteable()) {
                nodeIndex.delete();
            }
        } else if (this.rawGraph.index().existsForRelationships(indexName) && (relationshipIndex = this.rawGraph.index().forRelationships(indexName)).isWriteable()) {
            relationshipIndex.delete();
        }
        this.commit();
    }

    public Iterable<Index<? extends Element>> getIndices() {
        this.autoStartTransaction(false);
        ArrayList<Index<? extends Element>> indices = new ArrayList<Index<? extends Element>>();
        for (String name : this.rawGraph.index().nodeIndexNames()) {
            if (name.equals("node_auto_index")) continue;
            indices.add(new Neo4j2Index(name, Vertex.class, this, new Parameter[0]));
        }
        for (String name : this.rawGraph.index().relationshipIndexNames()) {
            if (name.equals("relationship_auto_index")) continue;
            indices.add(new Neo4j2Index(name, Edge.class, this, new Parameter[0]));
        }
        return indices;
    }

    public Neo4j2Vertex addVertex(Object id) {
        this.autoStartTransaction(true);
        return new Neo4j2Vertex(this.rawGraph.createNode(), this);
    }

    public Neo4j2Vertex getVertex(Object id) {
        this.autoStartTransaction(false);
        if (null == id) {
            throw ExceptionFactory.vertexIdCanNotBeNull();
        }
        try {
            Long longId = id instanceof Long ? (Long)id : (id instanceof Number ? Long.valueOf(((Number)id).longValue()) : Long.valueOf(Double.valueOf(id.toString()).longValue()));
            return new Neo4j2Vertex(this.rawGraph.getNodeById(longId.longValue()), this);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Iterable<Vertex> getVertices() {
        this.autoStartTransaction(false);
        return new Neo4j2VertexIterable(GlobalGraphOperations.at((GraphDatabaseService)this.rawGraph).getAllNodes(), this, this.checkElementsInTransaction());
    }

    public Iterable<Vertex> getVertices(String key, Object value) {
        this.autoStartTransaction(false);
        AutoIndexer indexer = this.rawGraph.index().getNodeAutoIndexer();
        if (indexer.isEnabled() && indexer.getAutoIndexedProperties().contains(key)) {
            return new Neo4j2VertexIterable((Iterable<Node>)this.rawGraph.index().getNodeAutoIndexer().getAutoIndex().get(key, value), this, this.checkElementsInTransaction());
        }
        return new PropertyFilteredIterable(key, value, this.getVertices());
    }

    public Iterable<Edge> getEdges() {
        this.autoStartTransaction(false);
        return new Neo4j2EdgeIterable(GlobalGraphOperations.at((GraphDatabaseService)this.rawGraph).getAllRelationships(), this, this.checkElementsInTransaction());
    }

    public Iterable<Edge> getEdges(String key, Object value) {
        this.autoStartTransaction(false);
        RelationshipAutoIndexer indexer = this.rawGraph.index().getRelationshipAutoIndexer();
        if (indexer.isEnabled() && indexer.getAutoIndexedProperties().contains(key)) {
            return new Neo4j2EdgeIterable((Iterable<Relationship>)this.rawGraph.index().getRelationshipAutoIndexer().getAutoIndex().get(key, value), this, this.checkElementsInTransaction());
        }
        return new PropertyFilteredIterable(key, value, this.getEdges());
    }

    public <T extends Element> void dropKeyIndex(String key, Class<T> elementClass) {
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        this.autoStartTransaction(true);
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (!this.rawGraph.index().getNodeAutoIndexer().isEnabled()) {
                return;
            }
            this.rawGraph.index().getNodeAutoIndexer().stopAutoIndexingProperty(key);
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            if (!this.rawGraph.index().getRelationshipAutoIndexer().isEnabled()) {
                return;
            }
            this.rawGraph.index().getRelationshipAutoIndexer().stopAutoIndexingProperty(key);
        } else {
            throw ExceptionFactory.classIsNotIndexable(elementClass);
        }
        this.dropInternalIndexKey(key, elementClass);
    }

    public <T extends Element> void createKeyIndex(String key, Class<T> elementClass, Parameter ... indexParameters) {
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        if (Vertex.class.isAssignableFrom(elementClass)) {
            this.autoStartTransaction(true);
            if (!this.rawGraph.index().getNodeAutoIndexer().isEnabled()) {
                this.rawGraph.index().getNodeAutoIndexer().setEnabled(true);
            }
            this.rawGraph.index().getNodeAutoIndexer().startAutoIndexingProperty(key);
            if (!this.getInternalIndexKeys(Vertex.class).contains(key)) {
                KeyIndexableGraphHelper.reIndexElements((Graph)this, this.getVertices(), new HashSet<String>(Arrays.asList(key)));
                this.autoStartTransaction(true);
                this.createInternalIndexKey(key, elementClass);
            }
        } else if (Edge.class.isAssignableFrom(elementClass)) {
            this.autoStartTransaction(true);
            if (!this.rawGraph.index().getRelationshipAutoIndexer().isEnabled()) {
                this.rawGraph.index().getRelationshipAutoIndexer().setEnabled(true);
            }
            this.rawGraph.index().getRelationshipAutoIndexer().startAutoIndexingProperty(key);
            if (!this.getInternalIndexKeys(Edge.class).contains(key)) {
                KeyIndexableGraphHelper.reIndexElements((Graph)this, this.getEdges(), new HashSet<String>(Arrays.asList(key)));
                this.autoStartTransaction(true);
                this.createInternalIndexKey(key, elementClass);
            }
        } else {
            throw ExceptionFactory.classIsNotIndexable(elementClass);
        }
    }

    public <T extends Element> Set<String> getIndexedKeys(Class<T> elementClass) {
        if (elementClass == null) {
            throw ExceptionFactory.classForElementCannotBeNull();
        }
        if (Vertex.class.isAssignableFrom(elementClass)) {
            if (!this.rawGraph.index().getNodeAutoIndexer().isEnabled()) {
                return Collections.emptySet();
            }
            return this.rawGraph.index().getNodeAutoIndexer().getAutoIndexedProperties();
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            if (!this.rawGraph.index().getRelationshipAutoIndexer().isEnabled()) {
                return Collections.emptySet();
            }
            return this.rawGraph.index().getRelationshipAutoIndexer().getAutoIndexedProperties();
        }
        throw ExceptionFactory.classIsNotIndexable(elementClass);
    }

    public void removeVertex(Vertex vertex) {
        this.autoStartTransaction(true);
        try {
            Node node = ((Neo4j2Vertex)vertex).getRawVertex();
            for (Relationship relationship : node.getRelationships(Direction.BOTH)) {
                relationship.delete();
            }
            node.delete();
        }
        catch (NotFoundException nfe) {
            throw ExceptionFactory.vertexWithIdDoesNotExist((Object)vertex.getId());
        }
        catch (IllegalStateException ise) {
            throw ExceptionFactory.vertexWithIdDoesNotExist((Object)vertex.getId());
        }
    }

    public Neo4j2Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        this.autoStartTransaction(true);
        return new Neo4j2Edge(((Neo4j2Vertex)outVertex).getRawVertex().createRelationshipTo(((Neo4j2Vertex)inVertex).getRawVertex(), (RelationshipType)DynamicRelationshipType.withName((String)label)), this);
    }

    public Neo4j2Edge getEdge(Object id) {
        if (null == id) {
            throw ExceptionFactory.edgeIdCanNotBeNull();
        }
        this.autoStartTransaction(true);
        try {
            Long longId = id instanceof Long ? (Long)id : Long.valueOf(Double.valueOf(id.toString()).longValue());
            return new Neo4j2Edge(this.rawGraph.getRelationshipById(longId.longValue()), this);
        }
        catch (NotFoundException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void removeEdge(Edge edge) {
        this.autoStartTransaction(true);
        ((Relationship)((Neo4j2Edge)edge).getRawElement()).delete();
    }

    public void stopTransaction(TransactionalGraph.Conclusion conclusion) {
        if (TransactionalGraph.Conclusion.SUCCESS == conclusion) {
            this.commit();
        } else {
            this.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (null == this.tx.get()) {
            return;
        }
        try {
            this.tx.get().success();
        }
        finally {
            this.tx.get().finish();
            this.tx.remove();
        }
    }

    public void rollback() {
        if (null == this.tx.get()) {
            return;
        }
        try {
            Transaction t = this.transactionManager.getTransaction();
            if (t == null || t.getStatus() == 4) {
                return;
            }
            this.tx.get().failure();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.tx.get().close();
            this.tx.remove();
        }
    }

    public void shutdown() {
        try {
            this.commit();
        }
        catch (TransactionFailureException e) {
            logger.warning("Failure on shutdown " + e.getMessage());
        }
        this.rawGraph.shutdown();
    }

    public void autoStartTransaction(boolean forWrite) {
        if (this.tx.get() == null) {
            this.tx.set(this.rawGraph.beginTx());
        }
    }

    public GraphDatabaseService getRawGraph() {
        return this.rawGraph;
    }

    public Features getFeatures() {
        return FEATURES;
    }

    public String toString() {
        return StringFactory.graphString((Graph)this, (String)this.rawGraph.toString());
    }

    public GraphQuery query() {
        return new DefaultGraphQuery((Graph)this);
    }

    public Iterator<Map<String, Object>> query(String query, Map<String, Object> params) {
        return this.cypher.execute(query, params == null ? Collections.emptyMap() : params).iterator();
    }

    public boolean nodeIsDeleted(long nodeId) {
        return ((AbstractTransactionManager)this.transactionManager).getTransactionState().nodeIsDeleted(nodeId);
    }

    public boolean relationshipIsDeleted(long nodeId) {
        return ((AbstractTransactionManager)this.transactionManager).getTransactionState().relationshipIsDeleted(nodeId);
    }

    static {
        Neo4j2Graph.FEATURES.supportsSerializableObjectProperty = false;
        Neo4j2Graph.FEATURES.supportsBooleanProperty = true;
        Neo4j2Graph.FEATURES.supportsDoubleProperty = true;
        Neo4j2Graph.FEATURES.supportsFloatProperty = true;
        Neo4j2Graph.FEATURES.supportsIntegerProperty = true;
        Neo4j2Graph.FEATURES.supportsPrimitiveArrayProperty = true;
        Neo4j2Graph.FEATURES.supportsUniformListProperty = true;
        Neo4j2Graph.FEATURES.supportsMixedListProperty = false;
        Neo4j2Graph.FEATURES.supportsLongProperty = true;
        Neo4j2Graph.FEATURES.supportsMapProperty = false;
        Neo4j2Graph.FEATURES.supportsStringProperty = true;
        Neo4j2Graph.FEATURES.supportsDuplicateEdges = true;
        Neo4j2Graph.FEATURES.supportsSelfLoops = true;
        Neo4j2Graph.FEATURES.isPersistent = true;
        Neo4j2Graph.FEATURES.isWrapper = false;
        Neo4j2Graph.FEATURES.supportsVertexIteration = true;
        Neo4j2Graph.FEATURES.supportsEdgeIteration = true;
        Neo4j2Graph.FEATURES.supportsVertexIndex = true;
        Neo4j2Graph.FEATURES.supportsEdgeIndex = true;
        Neo4j2Graph.FEATURES.ignoresSuppliedIds = true;
        Neo4j2Graph.FEATURES.supportsTransactions = true;
        Neo4j2Graph.FEATURES.supportsIndices = true;
        Neo4j2Graph.FEATURES.supportsKeyIndices = true;
        Neo4j2Graph.FEATURES.supportsVertexKeyIndex = true;
        Neo4j2Graph.FEATURES.supportsEdgeKeyIndex = true;
        Neo4j2Graph.FEATURES.supportsEdgeRetrieval = true;
        Neo4j2Graph.FEATURES.supportsVertexProperties = true;
        Neo4j2Graph.FEATURES.supportsEdgeProperties = true;
        Neo4j2Graph.FEATURES.supportsThreadedTransactions = false;
        Neo4j2Graph.FEATURES.supportsThreadIsolatedTransactions = true;
    }
}

