/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;

public class Neo4j2HaGraph
extends Neo4j2Graph {
    public Neo4j2HaGraph(String directory) {
        super(new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabase(directory));
    }

    public Neo4j2HaGraph(String directory, Map<String, String> configuration) {
        super(new HighlyAvailableGraphDatabaseFactory().newHighlyAvailableDatabaseBuilder(directory).setConfig(configuration).newGraphDatabase());
    }

    public Neo4j2HaGraph(HighlyAvailableGraphDatabase rawGraph) {
        super((GraphDatabaseService)rawGraph);
    }

    public Neo4j2HaGraph(Configuration configuration) {
        this(configuration.getString("blueprints.neo4jha.directory", null), Neo4j2HaGraph.convertConfiguration(configuration.subset("blueprints.neo4jha.conf")));
    }

    private static Map<String, String> convertConfiguration(Configuration configuration) {
        HashMap<String, String> c = new HashMap<String, String>();
        Iterator keys = configuration.getKeys();
        while (keys.hasNext()) {
            String k = (String)keys.next();
            c.put(k, configuration.getString(k));
        }
        return c;
    }
}

