/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Index;
import com.tinkerpop.blueprints.Parameter;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2EdgeIterable;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Element;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Vertex;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2VertexIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;

public class Neo4j2Index<T extends Neo4j2Element, S extends PropertyContainer>
implements Index<T> {
    private final Class<T> indexClass;
    protected final Neo4j2Graph graph;
    private final String indexName;
    protected org.neo4j.graphdb.index.Index<S> rawIndex;

    protected Neo4j2Index(String indexName, Class<T> indexClass, Neo4j2Graph graph, Parameter ... indexParameters) {
        this.indexClass = indexClass;
        this.graph = graph;
        this.indexName = indexName;
        this.generateIndex(indexParameters);
    }

    public Class<T> getIndexClass() {
        if (Vertex.class.isAssignableFrom(this.indexClass)) {
            return Vertex.class;
        }
        return Edge.class;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void put(String key, Object value, T element) {
        try {
            this.graph.autoStartTransaction(true);
            this.rawIndex.add(((Neo4j2Element)element).getRawElement(), key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public CloseableIterable<T> get(String key, Object value) {
        this.graph.autoStartTransaction(false);
        IndexHits itty = this.rawIndex.get(key, value);
        if (this.indexClass.isAssignableFrom(Neo4j2Vertex.class)) {
            return new Neo4j2VertexIterable((Iterable<Node>)itty, this.graph, this.graph.checkElementsInTransaction());
        }
        return new Neo4j2EdgeIterable((Iterable<Relationship>)itty, this.graph, this.graph.checkElementsInTransaction());
    }

    public CloseableIterable<T> query(String key, Object query) {
        this.graph.autoStartTransaction(false);
        IndexHits itty = this.rawIndex.query(key, query);
        if (this.indexClass.isAssignableFrom(Neo4j2Vertex.class)) {
            return new Neo4j2VertexIterable((Iterable<Node>)itty, this.graph, this.graph.checkElementsInTransaction());
        }
        return new Neo4j2EdgeIterable((Iterable<Relationship>)itty, this.graph, this.graph.checkElementsInTransaction());
    }

    public CloseableIterable<T> query(Object query) {
        this.graph.autoStartTransaction(false);
        IndexHits itty = this.rawIndex.query(query);
        if (this.indexClass.isAssignableFrom(Neo4j2Vertex.class)) {
            return new Neo4j2VertexIterable((Iterable<Node>)itty, this.graph, this.graph.checkElementsInTransaction());
        }
        return new Neo4j2EdgeIterable((Iterable<Relationship>)itty, this.graph, this.graph.checkElementsInTransaction());
    }

    public long count(String key, Object value) {
        this.graph.autoStartTransaction(false);
        if (!this.graph.checkElementsInTransaction()) {
            IndexHits hits = this.rawIndex.get(key, value);
            long count = hits.size();
            hits.close();
            return count;
        }
        CloseableIterable<T> hits = this.get(key, value);
        long count = 0L;
        for (Neo4j2Element t : hits) {
            ++count;
        }
        hits.close();
        return count;
    }

    public void remove(String key, Object value, T element) {
        try {
            this.graph.autoStartTransaction(true);
            this.rawIndex.remove(((Neo4j2Element)element).getRawElement(), key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void generateIndex(Parameter<Object, Object> ... indexParameters) {
        this.graph.autoStartTransaction(true);
        IndexManager manager = this.graph.getRawGraph().index();
        this.rawIndex = Vertex.class.isAssignableFrom(this.indexClass) ? (indexParameters.length > 0 ? manager.forNodes(this.indexName, Neo4j2Index.generateParameterMap(indexParameters)) : manager.forNodes(this.indexName)) : (indexParameters.length > 0 ? manager.forRelationships(this.indexName, Neo4j2Index.generateParameterMap(indexParameters)) : manager.forRelationships(this.indexName));
    }

    public String toString() {
        return StringFactory.indexString((Index)this);
    }

    private static Map<String, String> generateParameterMap(Parameter<Object, Object> ... indexParameters) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter<Object, Object> parameter : indexParameters) {
            map.put(parameter.getKey().toString(), parameter.getValue().toString());
        }
        return map;
    }

    public org.neo4j.graphdb.index.Index<S> getRawIndex() {
        return this.rawIndex;
    }
}

