/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.neo4j2;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Edge;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Element;
import com.tinkerpop.blueprints.impls.neo4j2.Neo4j2Graph;
import com.tinkerpop.blueprints.util.DefaultVertexQuery;
import com.tinkerpop.blueprints.util.MultiIterable;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class Neo4j2Vertex
extends Neo4j2Element
implements Vertex {
    public Neo4j2Vertex(Node node, Neo4j2Graph graph) {
        super(graph);
        this.rawElement = node;
    }

    public Iterable<Edge> getEdges(Direction direction, String ... labels) {
        this.graph.autoStartTransaction(false);
        if (direction.equals((Object)Direction.OUT)) {
            return new Neo4jVertexEdgeIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.OUTGOING, labels);
        }
        if (direction.equals((Object)Direction.IN)) {
            return new Neo4jVertexEdgeIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.INCOMING, labels);
        }
        return new MultiIterable(Arrays.asList(new Neo4jVertexEdgeIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.OUTGOING, labels), new Neo4jVertexEdgeIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.INCOMING, labels)));
    }

    public Iterable<Vertex> getVertices(Direction direction, String ... labels) {
        this.graph.autoStartTransaction(false);
        if (direction.equals((Object)Direction.OUT)) {
            return new Neo4jVertexVertexIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.OUTGOING, labels);
        }
        if (direction.equals((Object)Direction.IN)) {
            return new Neo4jVertexVertexIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.INCOMING, labels);
        }
        return new MultiIterable(Arrays.asList(new Neo4jVertexVertexIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.OUTGOING, labels), new Neo4jVertexVertexIterable(this.graph, (Node)this.rawElement, org.neo4j.graphdb.Direction.INCOMING, labels)));
    }

    public Edge addEdge(String label, Vertex vertex) {
        return this.graph.addEdge(null, this, vertex, label);
    }

    public Collection<String> getLabels() {
        this.graph.autoStartTransaction(false);
        ArrayList<String> labels = new ArrayList<String>();
        for (Label label : this.getRawVertex().getLabels()) {
            labels.add(label.name());
        }
        return labels;
    }

    public void addLabel(String label) {
        this.graph.autoStartTransaction(true);
        this.getRawVertex().addLabel(DynamicLabel.label((String)label));
    }

    public void removeLabel(String label) {
        this.graph.autoStartTransaction(true);
        this.getRawVertex().removeLabel(DynamicLabel.label((String)label));
    }

    public VertexQuery query() {
        this.graph.autoStartTransaction(false);
        return new DefaultVertexQuery((Vertex)this);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Neo4j2Vertex && ((Neo4j2Vertex)object).getId().equals(this.getId());
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Node getRawVertex() {
        return (Node)this.rawElement;
    }

    private class Neo4jVertexEdgeIterable<T extends Edge>
    implements Iterable<Neo4j2Edge> {
        private final Neo4j2Graph graph;
        private final Node node;
        private final org.neo4j.graphdb.Direction direction;
        private final DynamicRelationshipType[] labels;

        public Neo4jVertexEdgeIterable(Neo4j2Graph graph, Node node, org.neo4j.graphdb.Direction direction, String ... labels) {
            this.graph = graph;
            this.node = node;
            this.direction = direction;
            this.labels = new DynamicRelationshipType[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                this.labels[i] = DynamicRelationshipType.withName((String)labels[i]);
            }
        }

        @Override
        public Iterator<Neo4j2Edge> iterator() {
            this.graph.autoStartTransaction(false);
            final Iterator itty = this.labels.length > 0 ? this.node.getRelationships(this.direction, (RelationshipType[])this.labels).iterator() : this.node.getRelationships(this.direction).iterator();
            return new Iterator<Neo4j2Edge>(){

                @Override
                public Neo4j2Edge next() {
                    Neo4jVertexEdgeIterable.this.graph.autoStartTransaction(false);
                    return new Neo4j2Edge((Relationship)itty.next(), Neo4jVertexEdgeIterable.this.graph);
                }

                @Override
                public boolean hasNext() {
                    Neo4jVertexEdgeIterable.this.graph.autoStartTransaction(false);
                    return itty.hasNext();
                }

                @Override
                public void remove() {
                    Neo4jVertexEdgeIterable.this.graph.autoStartTransaction(true);
                    itty.remove();
                }
            };
        }
    }

    private class Neo4jVertexVertexIterable<T extends Vertex>
    implements Iterable<Neo4j2Vertex> {
        private final Neo4j2Graph graph;
        private final Node node;
        private final org.neo4j.graphdb.Direction direction;
        private final DynamicRelationshipType[] labels;

        public Neo4jVertexVertexIterable(Neo4j2Graph graph, Node node, org.neo4j.graphdb.Direction direction, String ... labels) {
            this.graph = graph;
            this.node = node;
            this.direction = direction;
            this.labels = new DynamicRelationshipType[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                this.labels[i] = DynamicRelationshipType.withName((String)labels[i]);
            }
        }

        @Override
        public Iterator<Neo4j2Vertex> iterator() {
            this.graph.autoStartTransaction(false);
            final Iterator itty = this.labels.length > 0 ? this.node.getRelationships(this.direction, (RelationshipType[])this.labels).iterator() : this.node.getRelationships(this.direction).iterator();
            return new Iterator<Neo4j2Vertex>(){

                @Override
                public Neo4j2Vertex next() {
                    Neo4jVertexVertexIterable.this.graph.autoStartTransaction(false);
                    return new Neo4j2Vertex(((Relationship)itty.next()).getOtherNode(Neo4jVertexVertexIterable.this.node), Neo4jVertexVertexIterable.this.graph);
                }

                @Override
                public boolean hasNext() {
                    Neo4jVertexVertexIterable.this.graph.autoStartTransaction(false);
                    return itty.hasNext();
                }

                @Override
                public void remove() {
                    Neo4jVertexVertexIterable.this.graph.autoStartTransaction(true);
                    itty.remove();
                }
            };
        }
    }
}

